

<?php $__env->startSection('action-content'); ?>

<!DOCTYPE html>
<html>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
<link href="https://fonts.googleapis.com/css?family=Raleway" rel="stylesheet">
<script src="jquery.js"></script>
<script src="<?php echo e(asset('js/bootstrap.js')); ?>"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3>Rollover Investment</h3>
                </div>
                <div class="panel-body">
                    <?php if(\Session::has('success')): ?>
                        <div class="alert alert-success">
                            <p><?php echo e(\Session::get('success')); ?></p>
                        </div>
                    <?php endif; ?>

<form class="form-horizontal" method="POST" id="form_id" action="<?php echo e(route('dailyinterestcal.update', $Dailyinterestcalculators->id)); ?>">
                        <?php echo e(csrf_field()); ?>

                        <?php echo e(method_field('PUT')); ?>


                        <div class="form-group">
                            <label for="clientaccount_number" class="col-md-2 control-label">Client Account Number</label>
                            <div class="col-md-4">
                                <input id="clientaccount_number" type="text" class="form-control" name="clientaccount_number" value="<?php echo e($Dailyinterestcalculators->clientaccount_number); ?>" readonly>
                            </div>

                            <label for="name" class="col-md-2 control-label">Client Name</label>
                            <div class="col-md-4">
                                <input id="name" type="text" class="form-control" name="name" value="<?php echo e($Dailyinterestcalculators->name); ?>" readonly>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="maturityvalue_amount" class="col-md-2 control-label">Maturity Value Amount</label>
                            <div class="col-md-4">
                                <input id="maturityvalue_amount" type="text" class="form-control" name="maturityvalue_amount" value="<?php echo e($Dailyinterestcalculators->maturityvalue_amount); ?>" readonly>
                            </div>

                            <label for="fundtype_id" class="col-md-2 control-label">Fund Type</label>
                            <div class="col-md-4">
                                <select class="form-control" name="fundtype_id" id="fundtype_id" readonly>
                                    <?php $__currentLoopData = $fundtype; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fundtypes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php echo e($Dailyinterestcalculators->fundtype_id == $fundtypes->id ? 'selected' : ''); ?> value="<?php echo e($fundtypes->id); ?>"><?php echo e($fundtypes->fundtype_name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="fixedincometype_id" class="col-md-2 control-label">Investment Type</label>
                            <div class="col-md-4">
                                <select class="form-control" name="fixedincometype_id" id="fixedincometype_id">
                                    <option value="-1">Please select Investment Type</option>
                                    <?php $__currentLoopData = $Fixedincometype; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Fixedincometypes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option <?php echo e($Dailyinterestcalculators->fixedincometype_id == $Fixedincometypes->id ? 'selected' : ''); ?> value="<?php echo e($Fixedincometypes->id); ?>"><?php echo e($Fixedincometypes->fixedincometype_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <label for="fixedincomeproduct_id" class="col-md-2 control-label">Investment Product</label>
                            <div class="col-md-4">
                                <select class="form-control" name="fixedincomeproduct_id" id="fixedincomeproduct_id">
                                    <option value="-1">Please select Investment Product</option>
                        <?php $__currentLoopData = $Fixedincomeproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Fixedincomeproducts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php echo e($Dailyinterestcalculators->fixedincomeproduct_id == $Fixedincomeproducts->id ? 'selected' : ''); ?> value="<?php echo e($Fixedincomeproducts->id); ?>"><?php echo e($Fixedincomeproducts->fixedincomeproduct_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="interestdaybasis_id" class="col-md-2 control-label">Interest Day Basis</label>
                            <div class="col-md-4">
                                <select class="form-control" name="interestdaybasis_id" id="interestdaybasis_id">
                                    <option value="-1">Please select Interest Day Basis</option>
                            <?php $__currentLoopData = $interestday; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interestdays): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option <?php echo e($Dailyinterestcalculators->interestdaybasis_id == $interestdays->id ? 'selected' : ''); ?> value="<?php echo e($interestdays->id); ?>"><?php echo e($interestdays->interestdaybasis); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <label for="tenor" class="col-md-2 control-label">Tenor (in days)</label>
                            <div class="col-md-4">
                                <input id="tenor" type="text" class="form-control" name="tenor" value="<?php echo e($Dailyinterestcalculators->tenor); ?>" placeholder="Enter tenor in days">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="interestratetype_id" class="col-md-2 control-label">Interest Type</label>
                            <div class="col-md-4">
                                <select class="form-control" name="interestratetype_id" id="interestratetype_id">
                                    <option value="-1">Please select Interest Type</option>
                            <?php $__currentLoopData = $Interestratetype; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Interestratetypes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php echo e($Dailyinterestcalculators->interestratetype_id == $Interestratetypes->id ? 'selected' : ''); ?> value="<?php echo e($Interestratetypes->id); ?>"><?php echo e($Interestratetypes->interestratetype); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

    <label for="interest_rate" class="col-md-2 control-label">Interest Rate (%)</label>
    <div class="col-md-4">
        <input id="interest_rate" type="text" class="form-control" name="interest_rate" 
               value="<?php echo e($Dailyinterestcalculators->interest_rate); ?>" placeholder="Enter interest rate" 
               oninput="calculateAnnualIntRate()">
    </div>
</div>

    <div class="form-group">
    <label for="counterparty_id" class="col-md-2 control-label">Counter Party</label>
                            <div class="col-md-4">
                                <select class="form-control" name="counterparty_id" id="counterparty_id">
                                    <option value="-1">Please select Counter Party</option>
                            <?php $__currentLoopData = $counterparty; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $counterpartys): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php echo e($Dailyinterestcalculators->counterparty_id == $counterpartys->id ? 'selected' : ''); ?> value="<?php echo e($counterpartys->id); ?>"><?php echo e($counterpartys->counterparty); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <hr>
<div class="form-group">
    <div class="col-sm-2 col-xs-1">
    <?php echo Form::button('Select All',['class' => 'btn btn-info form-control','onClick'=>'select_all("agree", "1")']); ?>

    </div>
    <label class="col-md-2 control-label">Date Of Transaction</label>
                            <div class="col-md-3">
                    <input id="incident_date" type="date" class="form-control" name="incident_date" value="<?php echo e(old('incident_date')); ?>">
                            </div>

       <div class="col-sm-2 col-xs-1">
    <?php echo Form::button('Clear All',['class' => 'btn btn-danger form-control','onClick'=>'select_all("agree", "0")']); ?>

    </div>

            </div>

    <div class="form-group <?php echo e($errors->has('annualint_rate') ? ' has-error' : ''); ?>">
    <label for="annualint_rate" class="col-md-1 control-label">Annual Interest Rate</label>
    <div class="col-md-2">
        <input id="annualint_rate" type="text" class="form-control" name="annualint_rate" 
               value="<?php echo e($Dailyinterestcalculators->annualint_rate); ?>" readonly>

        <?php if($errors->has('annualint_rate')): ?>
            <span class="help-block">
                <strong><?php echo e($errors->first('annualint_rate')); ?></strong>
            </span>
        <?php endif; ?>
    </div>


            <label class="col-md-1 control-label">Type of Transaction</label>
                            <div class="col-md-3">
                                <select class="form-control" name="transaction_id">
                                    <option value="-1">Please select Transaction</option>
                                    <?php $__currentLoopData = $Transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Transactions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option <?php echo e($Dailyinterestcalculators->transaction_id == $Transactions->id ? 'selected' : ''); ?> value="<?php echo e($Transactions->id); ?>"><?php echo e($Transactions->transaction_type); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

        <label for="narration" class="col-md-1 control-label">Narration </label>
                            <div class="col-md-3">
                                <input id="narration" type="text" class="form-control" name="narration" value="<?php echo e($Dailyinterestcalculators->narration); ?>">

                                <?php if($errors->has('narration')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('narration')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                    </div>
                       <div class="form-group">
                            <label for="investmentstart_date" class="col-md-2 control-label">Investment Start Date</label>
                            <div class="col-md-4">
                                <input id="investmentstart_date" type="date" class="form-control" name="investmentstart_date" value="<?php echo e($Dailyinterestcalculators->investmentend_date); ?>">
                            </div>

                            <label for="investmentend_date" class="col-md-2 control-label">Maturity Date</label>
                            <div class="col-md-4">
                                <input type="date" value="<?php echo e(old('investmentend_date')); ?>"
                                    name="investmentend_date"class="form-control pull-right"
                                    id="investmentend_date" readonly>
                            </div>
<div class="form-group"> 
    <div class="col-sm-4 col-md-offset-9">
                                <button type="submit" class="btn btn-primary">Submit Rollover</button>
        <a href="<?php echo e(route('dailyinterestcal.index')); ?>" class="btn btn-default">Cancel</a>
                            </div>
                        </div>
                    </div>
                   
<?php
    // Fetch all relevant records for the client account number
    $dailyInterestCalculatorsList = $Dailyinterestcalculators->where('clientaccount_number', $Dailyinterestcalculators->clientaccount_number)->get();
?>

<?php if($dailyInterestCalculatorsList->isNotEmpty()): ?>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
        <div class="table-responsive">
            <div class="col-sm-12">
                <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
                    <thead>
                        <tr role="row">
                            <th width="3%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="questionCheckBox: activate to sort column ascending"></th>
                            <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                            <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Name</th>
                            <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="maturityvalue_amount: activate to sort column ascending">Maturity Value Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $dailyInterestCalculatorsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dailyInterest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr role="row" class="odd">
                                <td class="text-left">
                                    <?php echo Form::checkbox("agree[]", $dailyInterest->clientaccount_number, null, ['id' => $dailyInterest->clientaccount_number], ['class' => 'questionCheckbox']); ?>

                                </td>
                                <td><?php echo e($dailyInterest->clientaccount_number); ?></td>
                                <td><?php echo e($dailyInterest->name); ?></td>
                                <td><?php echo e($dailyInterest->maturityvalue_amount); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php endif; ?>
                    </form>

                </div>
                  <script type="text/javascript">

    var formblock;
    var forminputs;

    function prepare() {
        formblock= document.getElementById('form_id');
        forminputs = formblock.getElementsByTagName('input');
    }

    function select_all(name, value) {
        for (i = 0; i < forminputs.length; i++) {
            // regex here to check name attribute
            var regex = new RegExp(name, "i");
            if (regex.test(forminputs[i].getAttribute('name'))) {
                if (value == '1') {
                    forminputs[i].checked = true;
                } else {
                    forminputs[i].checked = false;
                }
            }
        }
    }

    if (window.addEventListener) {
        window.addEventListener("load", prepare, false);
    } else if (window.attachEvent) {
        window.attachEvent("onload", prepare)
    } else if (document.getElementById) {
        window.onload = prepare;
    }


    $(document).ready(function() {
    $('#tenor, #investmentstart_date').on('input', function() {
        calculateEndDate();
    });

    function calculateEndDate() {
        const startDate = new Date($('#investmentstart_date').val());
        const tenorDays = parseInt($('#tenor').val());

        if (!isNaN(startDate.getTime()) && !isNaN(tenorDays)) {
            const endDate = new Date(startDate);
            endDate.setDate(startDate.getDate() + tenorDays); // Add tenor days to the start date
            
            // Format the date as YYYY-MM-DD
            const formattedEndDate = endDate.toISOString().split('T')[0];
            
            $('#investmentend_date').val(formattedEndDate);
        }
    }
});
    function calculateAnnualIntRate() {
        let interestRate = document.getElementById('interest_rate').value;

        // Ensure the interest rate is a valid number before calculating
        if (!isNaN(interestRate) && interestRate !== '') {
            let annualIntRate = (parseFloat(interestRate) / 100) / 364;

            // Set the calculated value in the annualint_rate input field
            document.getElementById('annualint_rate').value = annualIntRate.toFixed(6);  // Six decimal places for precision
        } else {
            // Clear the field if the input is not a number
            document.getElementById('annualint_rate').value = '';
        }
    }

    // Trigger the calculation on page load if interest_rate already has a value
    document.addEventListener('DOMContentLoaded', function() {
        if (document.getElementById('interest_rate').value) {
            calculateAnnualIntRate();
        }
    });
</script>
            </div>
        </div>
    </div>

</div>

   
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dailyinterestcal.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sicbrok1/public_html/apps.sicbrokerage.com/Assetmgt/resources/views/dailyinterestcal/edit.blade.php ENDPATH**/ ?>