<?php $__env->startSection('action-content'); ?>
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">List of Individual clients</h3>
        </div>
        <?php if(\Session::has('success')): ?>
      <div class="alert alert-success">
        <p><?php echo e(\Session::get('success')); ?></p>
      </div><br />
     <?php endif; ?>
        <div class="col-sm-4">
          <a class="btn btn-primary" href="<?php echo e(route('employee-management.create')); ?>">Add New Individual Client</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="<?php echo e(route('employee-management.search')); ?>">
         <?php echo e(csrf_field()); ?>

         <?php $__env->startComponent('layouts.search', ['title' => 'Search']); ?>
          <?php $__env->startComponent('layouts.two-cols-search-row', ['items' => ['firstname', 'clientaccount_number'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['firstname'] : '', isset($searchingVals) ? $searchingVals['clientaccount_number'] : '']]); ?>
          <?php echo $__env->renderComponent(); ?>
        <?php echo $__env->renderComponent(); ?>
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap" >
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info" >
            <thead>
              <tr role="table-responsive">
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="passportpicture: activate to sort column descending" aria-sort="ascending">Passport Picture</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="title: activate to sort column ascending">Title</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="sex: activate to sort column ascending">Gender</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="accounttype: activate to sort column ascending">Type of Account</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Investment Category</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="maritalstatus: activate to sort column ascending">Marital Status</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="birthdate: activate to sort column ascending">Date Of Birth</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="age: activate to sort column ascending">Age</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="place_of_birth: activate to sort column ascending">Place Of Birth</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="maidenname: activate to sort column ascending">mother's Maiden Name</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="residential_type: activate to sort column ascending">Residential Status</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country_name: activate to sort column ascending">Country Of Origin</th>
                <?php if($employees->count() > 0): ?> <!-- Check if there are employees to determine country_id -->
            <?php
                $firstEmployee = $employees->first(); // Get the first employee
            ?>

            <?php if($firstEmployee->country_id != 1): ?> <!-- Check if country_id of the first employee is not 1 -->
                <!-- Headings related to country_id != 1 -->
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="residential_permit: activate to sort column ascending">Residential Permit Number</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="permit_issue_date: activate to sort column ascending">Permit Issue Date</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="place_of_issue_of_permit: activate to sort column ascending">Permit Place Of Issue</th>
            <?php endif; ?>
        <?php endif; ?>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="countryresidence: activate to sort column ascending">Country Of Residence</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="occupation: activate to sort column ascending">Occupation</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="profession: activate to sort column ascending">Profession</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="tin: activate to sort column ascending">Tin</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="residential_address: activate to sort column ascending">Residential Address</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="nearest_landmark_contact: activate to sort column ascending">Nearest Landmark Contact</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="digital_address: activate to sort column ascending">Digital Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="postal_address: activate to sort column ascending">Postal Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address_contact: activate to sort column ascending">Email Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="mobile_number: activate to sort column ascending">Mobile Number</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="emergency_contact_name: activate to sort column ascending">Contact Name(emergency)</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="emergency_contact_number: activate to sort column ascending">Contact number(emergency)</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="relationship_to_client: activate to sort column ascending">Relationship to Client(emergency)</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="identification_type: activate to sort column ascending">Type of Identification</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="identification_number: activate to sort column ascending">Identification Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="ID_issue_date: activate to sort column ascending">ID Issue Date</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="ID_place_of_issue: activate to sort column ascending">ID Place Of Issue</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="ID_expiry_date: activate to sort column ascending">ID Expiry Date</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="statementservice_type: activate to sort column ascending">Mode Of Statement Delivery</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="statementfrequency_type: activate to sort column ascending">Statement Frequency</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="other_statementfrequency: activate to sort column ascending">Other Statement Frequency</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employerstatus_type: activate to sort column ascending">Employment Status</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employment_years: activate to sort column ascending">Years of Employment</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employmentcurrent_years: activate to sort column ascending">Years of Current Employment</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employmentprevious_years: activate to sort column ascending">Years of Previous Employment</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employeeincome_range: activate to sort column ascending">Monthly Income Range</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employer_name: activate to sort column ascending">Emp/Bus/Sch Name</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employer_address: activate to sort column ascending">Emp/Bus/Sch Address</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="nearest_landmark_employer: activate to sort column ascending">Emp/Bus/Sch Landmark</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="digital_address_employer: activate to sort column ascending">Emp/Bus/Sch GPS</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="city_town_employer: activate to sort column ascending">Emp/Bus/Sch City/Town</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="nature_of_business: activate to sort column ascending">Nature of Business</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number_employer: activate to sort column ascending">Emp/Bus/Sch Contact</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="mobile_number_employer: activate to sort column ascending">Emp/Bus/Sch Contact</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address_employer: activate to sort column ascending">Emp/Bus/Sch Email</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="PictureID: activate to sort column descending" aria-sort="ascending">ID Picture</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="signature_upload: activate to sort column descending" aria-sort="ascending">Signature Specimen Upload</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: activate to sort column descending" aria-sort="ascending">Account Status</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr role="row" class="odd">
                  <td><a href="<?php echo e(route('employee-management.show', $employee->id)); ?>"><img src="<?php echo e(asset('storage/app/public/' .$employee->passportpicture)); ?>" width="60px" height="60px"/></a></td>
                  <td class="hidden-xs"><?php echo e($employee->clientaccount_number); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->title_name); ?></td>
                  <td class="sorting_1"><a href="<?php echo e(url('other-employee-details/nextofkin/'.$employee->id)); ?>"><?php echo e($employee->firstname); ?> <?php echo e($employee->middlename); ?> <?php echo e($employee->lastname); ?></a> </td>
                  <td class="hidden-xs"><?php echo e($employee->sex_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->account_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->fundtype_name); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->maritalstatus_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->birthdate); ?></td>
                  <td class="hidden-xs"><?php echo e(\Carbon\Carbon::parse($employee->birthdate)->age); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->place_of_birth); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->maidenname); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->residential_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->country_name); ?></td>
            <!-- Conditionally show or hide fields based on country_id -->
                  <?php if($employee->country_id == 2): ?>
                  <td><?php echo e($employee->residential_permit); ?></td>
                  <td><?php echo e($employee->permit_issue_date); ?></td>
                  <td><?php echo e($employee->place_of_issue_of_permit); ?></td>
                  <td><?php echo e($employee->permit_expiry_date); ?></td>
                  <?php endif; ?>
                  <td class="hidden-xs"><?php echo e($employee->countryresidence); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->occupation); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->profession); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->tin); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->residential_address); ?></td>
                <td class="hidden-xs"><?php echo e($employee->nearest_landmark_contact); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->digital_address_contact); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->postal_address); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->email_address_contact); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->mobile_number); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->phone_number); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->emergency_contact_name); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->emergency_contact_number); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->relationship_to_client); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->identification_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->identification_number); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->ID_issue_date); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->ID_place_of_issue); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->ID_expiry_date); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->statementservice_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->statementfrequency_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->other_statementfrequency); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->employerstatus_type); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->employment_years); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->employmentcurrent_years); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->employmentprevious_years); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->employeeincome_range); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->employer_name); ?></td>
                  <td class="hidden-xs"><?php echo e($employee->employer_address); ?></td>
                <td class="hidden-xs"><?php echo e($employee->nearest_landmark_employer); ?></td>
                <td class="hidden-xs"><?php echo e($employee->digital_address_employer); ?></td>
                <td class="hidden-xs"><?php echo e($employee->city_town_employer); ?></td>
                <td class="hidden-xs"><?php echo e($employee->nature_of_business); ?></td>
                <td class="hidden-xs"><?php echo e($employee->phone_number_employer); ?></td>
                <td class="hidden-xs"><?php echo e($employee->mobile_number_employer); ?></td>
                <td class="hidden-xs"><?php echo e($employee->email_address_employer); ?></td>
                  
                  <td> <img src="<?php echo e(asset('storage/app/public/'.$employee->pictureID)); ?>" width="60px" height="60px"/></a></td>
                  <td> <img src="<?php echo e(asset('storage/app/public/'.$employee->signature_upload)); ?>" width="60px" height="60px"/></a></td>
                  <td class="hidden-xs"><?php echo e($employee->active_type); ?></td>
                  <td>
                    <form class="row" method="POST" action="<?php echo e(route('employee-management.destroy', $employee->id)); ?>" onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <a href="<?php echo e(route('employee-management.edit', $employee->id)); ?>" class="glyphicon glyphicon-pencil btn-warning col-sm-10 col-xs-10 btn-margin" title="Update KYC">
                        Update
                        </a>
                         <button type="submit" class="glyphicon glyphicon-trash btn-danger col-sm-10 col-xs-10 btn-margin" title="Delete KYC">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
              <tr>
                
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to <?php echo e(count($employees)); ?> of <?php echo e(count($employees)); ?> entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            <?php echo e($employees->links()); ?>

          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('employees-mgmt.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sicbrok1/public_html/apps.sicbrokerage.com/Assetmgt/resources/views/employees-mgmt/index.blade.php ENDPATH**/ ?>