@extends('withdrawal.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">List of Clients Withdrawal List</h3>
        </div>
        @if (\Session::has('success'))
      <div class="alert alert-success">
        <p>{{ \Session::get('success') }}</p>
      </div><br />
     @endif
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('withdrawalform.create') }}">Add New Withdrawal Request</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('withdrawalform.search') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['date_processed'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['date_processed'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap" >
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info" >
            <thead>
              <tr role="table-responsive">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="accounttype: activate to sort column ascending">Type of Account</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Investment Category</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name_on_investment: activate to sort column ascending">Name on Investment Account</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="postal_address: activate to sort column ascending">Postal Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address: activate to sort column ascending">Email Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="mobile_number: activate to sort column ascending">Mobile Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="amount_in_figures: activate to sort column descending" aria-sort="ascending">Amount In Figures(GHs)</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="amount_in_words: activate to sort column ascending">Amount In Words</th>
                
                
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="maritalstatus: activate to sort column ascending">Marital Status</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="birthdate: activate to sort column ascending">Date Of Birth</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="age: activate to sort column ascending">Age</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="place_of_birth: activate to sort column ascending">Place Of Birth</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="maidenname: activate to sort column ascending">mother's Maiden Name</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="residential_type: activate to sort column ascending">Residential Status</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country_name: activate to sort column ascending">Country Of Origin</th>
                @if($employees->count() > 0) <!-- Check if there are employees to determine country_id -->
            @php
                $firstEmployee = $employees->first(); // Get the first employee
            @endphp

            @if($firstEmployee->country_id != 1) <!-- Check if country_id of the first employee is not 1 -->
                <!-- Headings related to country_id != 1 -->
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="residential_permit: activate to sort column ascending">Residential Permit Number</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="permit_issue_date: activate to sort column ascending">Permit Issue Date</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="place_of_issue_of_permit: activate to sort column ascending">Permit Place Of Issue</th>
            @endif
        @endif
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="countryresidence: activate to sort column ascending">Country Of Residence</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="occupation: activate to sort column ascending">Occupation</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="profession: activate to sort column ascending">Profession</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="tin: activate to sort column ascending">Tin</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="residential_address: activate to sort column ascending">Residential Address</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="nearest_landmark_contact: activate to sort column ascending">Nearest Landmark Contact</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="digital_address: activate to sort column ascending">Digital Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="postal_address: activate to sort column ascending">Postal Address</th>
                
                
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="emergency_contact_name: activate to sort column ascending">Contact Name(emergency)</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="emergency_contact_number: activate to sort column ascending">Contact number(emergency)</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="relationship_to_client: activate to sort column ascending">Relationship to Client(emergency)</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="identification_type: activate to sort column ascending">Type of Identification</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="identification_number: activate to sort column ascending">Identification Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="ID_issue_date: activate to sort column ascending">ID Issue Date</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="ID_place_of_issue: activate to sort column ascending">ID Place Of Issue</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="ID_expiry_date: activate to sort column ascending">ID Expiry Date</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="statementservice_type: activate to sort column ascending">Mode Of Statement Delivery</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="statementfrequency_type: activate to sort column ascending">Statement Frequency</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="other_statementfrequency: activate to sort column ascending">Other Statement Frequency</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employerstatus_type: activate to sort column ascending">Employment Status</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employment_years: activate to sort column ascending">Years of Employment</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employmentcurrent_years: activate to sort column ascending">Years of Current Employment</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employmentprevious_years: activate to sort column ascending">Years of Previous Employment</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employeeincome_range: activate to sort column ascending">Monthly Income Range</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employer_name: activate to sort column ascending">Emp/Bus/Sch Name</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employer_address: activate to sort column ascending">Emp/Bus/Sch Address</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="nearest_landmark_employer: activate to sort column ascending">Emp/Bus/Sch Landmark</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="digital_address_employer: activate to sort column ascending">Emp/Bus/Sch GPS</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="city_town_employer: activate to sort column ascending">Emp/Bus/Sch City/Town</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="nature_of_business: activate to sort column ascending">Nature of Business</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number_employer: activate to sort column ascending">Emp/Bus/Sch Contact</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="mobile_number_employer: activate to sort column ascending">Emp/Bus/Sch Contact</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address_employer: activate to sort column ascending">Emp/Bus/Sch Email</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="PictureID: activate to sort column descending" aria-sort="ascending">ID Picture</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="signature_upload: activate to sort column descending" aria-sort="ascending">Signature Specimen Upload</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: activate to sort column descending" aria-sort="ascending">Account Status</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
            @foreach ($employees as $employee)
                <tr role="row" class="odd">
                  <td> <a href="{{ route('employee-management.show', ['id' => $employee->id]) }}"> <img src="../{{$employee->passportpicture}}" width="60px" height="60px"/></a></td>
                  <td class="hidden-xs">{{ $employee->clientaccount_number }}</td>
                  <td class="hidden-xs">{{ $employee->title_name }}</td>
                  <td class="sorting_1"><a href="{{url('other-employee-details/nextofkin/'.$employee->id)}}">{{ $employee->firstname }} {{$employee->middlename}} {{$employee->lastname}}</a> </td>
                  <td class="hidden-xs">{{ $employee->sex_type }}</td>
                  <td class="hidden-xs">{{ $employee->account_type }}</td>
                  <td class="hidden-xs">{{ $employee->fundtype_name }}</td>
                  <td class="hidden-xs">{{ $employee->maritalstatus_type }}</td>
                  <td class="hidden-xs">{{ $employee->birthdate }}</td>
                  <td class="hidden-xs">{{ \Carbon\Carbon::parse($employee->birthdate)->age }}</td>
                  <td class="hidden-xs">{{ $employee->place_of_birth }}</td>
                  <td class="hidden-xs">{{ $employee->maidenname }}</td>
                  <td class="hidden-xs">{{ $employee->residential_type }}</td>
                  <td class="hidden-xs">{{ $employee->country_name }}</td>
            <!-- Conditionally show or hide fields based on country_id -->
                  @if($employee->country_id == 2)
                  <td>{{ $employee->residential_permit }}</td>
                  <td>{{ $employee->permit_issue_date }}</td>
                  <td>{{ $employee->place_of_issue_of_permit }}</td>
                  @endif
                  <td class="hidden-xs">{{ $employee->countryresidence }}</td>
                  <td class="hidden-xs">{{ $employee->occupation }}</td>
                  <td class="hidden-xs">{{ $employee->profession }}</td>
                  <td class="hidden-xs">{{ $employee->tin }}</td>
                  <td class="hidden-xs">{{ $employee->residential_address }}</td>
                <td class="hidden-xs">{{ $employee->nearest_landmark_contact }}</td>
                  <td class="hidden-xs">{{ $employee->digital_address_contact }}</td>
                  <td class="hidden-xs">{{ $employee->postal_address}}</td>
                  <td class="hidden-xs">{{ $employee->email_address_contact }}</td>
                  <td class="hidden-xs">{{ $employee->mobile_number}}</td>
                  <td class="hidden-xs">{{ $employee->phone_number }}</td>
                  <td class="hidden-xs">{{ $employee->emergency_contact_name}}</td>
                  <td class="hidden-xs">{{ $employee->emergency_contact_number }}</td>
                  <td class="hidden-xs">{{ $employee->relationship_to_client }}</td>
                  <td class="hidden-xs">{{ $employee->identification_type}}</td>
                  <td class="hidden-xs">{{ $employee->identification_number }}</td>
                  <td class="hidden-xs">{{ $employee->ID_issue_date}}</td>
                  <td class="hidden-xs">{{ $employee->ID_place_of_issue }}</td>
                  <td class="hidden-xs">{{ $employee->ID_expiry_date}}</td>
                  <td class="hidden-xs">{{ $employee->statementservice_type}}</td>
                  <td class="hidden-xs">{{ $employee->statementfrequency_type }}</td>
                  <td class="hidden-xs">{{ $employee->other_statementfrequency}}</td>
                  <td class="hidden-xs">{{ $employee->employerstatus_type}}</td>
                  <td class="hidden-xs">{{ $employee->employment_years}}</td>
                  <td class="hidden-xs">{{ $employee->employmentcurrent_years}}</td>
                  <td class="hidden-xs">{{ $employee->employmentprevious_years}}</td>
                  <td class="hidden-xs">{{ $employee->employeeincome_range}}</td>
                  <td class="hidden-xs">{{ $employee->employer_name}}</td>
                  <td class="hidden-xs">{{ $employee->employer_address}}</td>
                <td class="hidden-xs">{{ $employee->nearest_landmark_employer}}</td>
                <td class="hidden-xs">{{ $employee->digital_address_employer}}</td>
                <td class="hidden-xs">{{ $employee->city_town_employer}}</td>
                <td class="hidden-xs">{{ $employee->nature_of_business}}</td>
                <td class="hidden-xs">{{ $employee->phone_number_employer}}</td>
                <td class="hidden-xs">{{ $employee->mobile_number_employer}}</td>
                <td class="hidden-xs">{{ $employee->email_address_employer}}</td>
                  
                  <td> <img src="../{{$employee->pictureID}}" width="60px" height="60px"/></a></td>
                  <td> <img src="../{{$employee->signature_upload}}" width="60px" height="60px"/></a></td>
                  <td class="hidden-xs">{{ $employee->active_type}}</td>
                  <td>
                    <form class="row" method="POST" action="{{ route('employee-management.destroy', ['id' => $employee->id]) }}" onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <a href="{{ route('employee-management.edit', ['id' => $employee->id]) }}" class="glyphicon glyphicon-pencil btn-warning col-sm-10 col-xs-10 btn-margin">
                        Update
                        </a>
                         <button type="submit" class="glyphicon glyphicon-trash btn-danger col-sm-10 col-xs-10 btn-margin">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
            @endforeach
            </tbody>
            <tfoot>
              <tr>
                
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($employees)}} of {{count($employees)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $employees->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection