@extends('system-mgmt.withdrawal.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new Withdrawal Frequency</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('withdrawal.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('withdrawal') ? ' has-error' : '' }}">
                            <label for="topup" class="col-md-4 control-label">Withdrawal Frequency</label>

                            <div class="col-md-6">
                                <input id="withdrawal" type="text" class="form-control" name="withdrawal" value="{{ old('withdrawal') }}" required autofocus>

                                @if ($errors->has('withdrawal'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('withdrawal') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
