@extends('system-mgmt.transaction.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Transaction Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('transaction.update', $Transactions->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('transaction_type') ? ' has-error' : '' }}">
                            <label for="transaction_type" class="col-md-4 control-label">Transaction Type</label>

                            <div class="col-md-6">
                                <input id="transaction_type" type="text" class="form-control" name="transaction_type" value="{{ $Transactions->transaction_type}}" required autofocus>

                                @if ($errors->has('transaction_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('transaction_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
