@extends('system-mgmt.transaction.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Transaction type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('transaction.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('Transaction') ? ' has-error' : '' }}">
                            <label for="transaction_type" class="col-md-4 control-label">Transaction Type</label>

                            <div class="col-md-6">
                                <input id="transaction_type" type="text" class="form-control" name="transaction_type" value="{{ old('transaction_type') }}" required autofocus>

                                @if ($errors->has('transaction_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('transaction_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
