@extends('system-mgmt.title.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Title Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('title.update', $titles->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('title_name') ? ' has-error' : '' }}">
                            <label for="title_name" class="col-md-4 control-label">Title Type</label>

                            <div class="col-md-6">
                                <input id="title_name" type="text" class="form-control" name="title_name" value="{{ $titles->title_name }}" required autofocus>

                                @if ($errors->has('title_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
