@extends('system-mgmt.statementfrequency.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Statement Delivery Frequency</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('statementfrequency.update', $statementfrequencies->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('statementfrequency_type') ? ' has-error' : '' }}">
                            <label for="statementfrequency_type" class="col-md-4 control-label">Statement Delivery Frequency Type</label>

                            <div class="col-md-6">
                                <input id="statementfrequency_type" type="text" class="form-control" name="statementfrequency_type" value="{{ $statementfrequencies->statementfrequency_type }}" required autofocus>

                                @if ($errors->has('statementfrequency_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('statementfrequency_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
