@extends('system-mgmt.sourceoffund.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Source of Funds</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('sourceoffund.update', $sourceoffunds->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('source_type') ? ' has-error' : '' }}">
                            <label for="source_type" class="col-md-4 control-label">Type of Source Funding</label>

                            <div class="col-md-6">
                                <input id="source_type" type="text" class="form-control" name="source_type" value="{{ $sourceoffunds->source_type }}" required autofocus>

                                @if ($errors->has('source_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('source_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
