@extends('system-mgmt.signaturemandate.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new Signature Mandate Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('signaturemandate.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('signaturemandate_type') ? ' has-error' : '' }}">
                            <label for="signaturemandate_type" class="col-md-4 control-label">Signature Mandate Type</label>

                            <div class="col-md-6">
                                <input id="signaturemandate_type" type="text" class="form-control" name="signaturemandate_type" value="{{ old('signaturemandate_type') }}" required autofocus>

                                @if ($errors->has('signaturemandate_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('signaturemandate_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
