@extends('system-mgmt.sex.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Sex status</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('sex.update', $sexs->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('sex_type') ? ' has-error' : '' }}">
                            <label for="sex_type" class="col-md-4 control-label">Gender Type</label>

                            <div class="col-md-6">
                                <input id="sex_type" type="text" class="form-control" name="sex_type" value="{{ $sexs->sex_type }}" required autofocus>

                                @if ($errors->has('sex_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sex_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
