@extends('system-mgmt.residential.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Residential Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('residential.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('residential_type') ? ' has-error' : '' }}">
                            <label for="residential_type" class="col-md-4 control-label">Residential Status</label>

                            <div class="col-md-6">
                                <input id="residential_type" type="text" class="form-control" name="residential_type" value="{{ old('residential_type') }}" required autofocus>

                                @if ($errors->has('residential_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('residential_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
