@extends('system-mgmt.paymentoption.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Payment Options</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('paymentoption.update', $paymentoption->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('paymentoption') ? ' has-error' : '' }}">
                            <label for="paymentoption" class="col-md-4 control-label">Mode Of Account</label>

                            <div class="col-md-6">
                                <input id="paymentoption" type="text" class="form-control" name="paymentoption" value="{{ $paymentoption->paymentoption }}" required autofocus>

                                @if ($errors->has('paymentoption'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('paymentoption') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
