@extends('system-mgmt.paymentoption.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Payment Option</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('paymentoption.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('paymentoption') ? ' has-error' : '' }}">
                            <label for="paymentoption" class="col-md-4 control-label">Payment Options</label>

                            <div class="col-md-6">
                                <input id="paymentoption" type="text" class="form-control" name="paymentoption" value="{{ old('paymentoption') }}" required autofocus>

                                @if ($errors->has('paymentoption'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('paymentoption') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
