@extends('system-mgmt.modeofaccount.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new Mode of Account</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('modeofaccount.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('modeofaccount') ? ' has-error' : '' }}">
                            <label for="modeofaccount" class="col-md-4 control-label">Mode Of Account</label>

                            <div class="col-md-6">
                                <input id="modeofaccount" type="text" class="form-control" name="modeofaccount" value="{{ old('modeofaccount') }}" required autofocus>

                                @if ($errors->has('modeofaccount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('modeofaccount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
