@extends('system-mgmt.maritalstatus.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new marital status</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('maritalstatus.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('maritalstatus_type') ? ' has-error' : '' }}">
                            <label for="maritalstatus_type" class="col-md-4 control-label">Marital Status Name</label>

                            <div class="col-md-6">
                                <input id="maritalstatus_type" type="text" class="form-control" name="maritalstatus_type" value="{{ old('maritalstatus_type') }}" required autofocus>

                                @if ($errors->has('maritalstatus_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('maritalstatus_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
