@extends('system-mgmt.investmenttframe.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Investment Time Frame</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('investmenttframe.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('investmenttframe_type') ? ' has-error' : '' }}">
                            <label for="investmenttframe_type" class="col-md-4 control-label">Investment Time Frame</label>

                            <div class="col-md-6">
                                <input id="investmenttframe_type" type="text" class="form-control" name="investmenttframe_type" value="{{ old('investmenttframe_type') }}" required autofocus>

                                @if ($errors->has('investmenttframe_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('investmenttframe_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
