@extends('system-mgmt.investmentknowledge.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new Investment Knowledge</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('investmentknowledge.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('investmentknowledge') ? ' has-error' : '' }}">
                            <label for="investmentknowledge" class="col-md-4 control-label">Investment Knowledge</label>

                            <div class="col-md-6">
                                <input id="investmentknowledge" type="text" class="form-control" name="investmentknowledge" value="{{ old('investmentknowledge') }}" required autofocus>

                                @if ($errors->has('investmentknowledge'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('investmentknowledge') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
