@extends('system-mgmt.identificationtype.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Identification Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('identificationtype.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('identification_type') ? ' has-error' : '' }}">
                            <label for="identification_type" class="col-md-4 control-label">Identification Type</label>

                            <div class="col-md-6">
                                <input id="identification_type" type="text" class="form-control" name="identification_type" value="{{ old('identification_type') }}" required autofocus>

                                @if ($errors->has('identification_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('identification_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
