@extends('system-mgmt.fundtype.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Fund Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('fundtype.update', $fundtypes->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('fundtype_name') ? ' has-error' : '' }}">
                            <label for="fundtype_name" class="col-md-4 control-label">Fund Type</label>

                            <div class="col-md-6">
                                <input id="fundtype_name" type="text" class="form-control" name="fundtype_name" value="{{ $fundtypes->fundtype_name }}" required autofocus>

                                @if ($errors->has('fundtype_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fundtype_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
