@extends('system-mgmt.interest.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Interest Amount</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('interest.update', $interests->id) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('interest_amount') ? ' has-error' : '' }}">
                            <label for="interest_amount" class="col-md-4 control-label">Interest Amount</label>

                            <div class="col-md-6">
                                <input id="interest_amount" type="text" class="form-control" name="interest_amount" value="{{ $interests->interest_amount }}" required autofocus>

                                @if ($errors->has('interest_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('interest_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
