@extends('system-mgmt.feedback.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Feedback Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('feedback.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('feedback_type') ? ' has-error' : '' }}">
                            <label for="feedback_type" class="col-md-4 control-label">Feedbacks</label>

                            <div class="col-md-6">
                                <input id="feedback_type" type="text" class="form-control" name="feedback_type" value="{{ old('feedback_type') }}" required autofocus>

                                @if ($errors->has('feedback_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('feedback_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
