@extends('system-mgmt.employerstatus.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new employer status</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('employerstatus.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('employerstatus_type') ? ' has-error' : '' }}">
                            <label for="employerstatus_type" class="col-md-4 control-label">Employer Status</label>

                            <div class="col-md-6">
                                <input id="employerstatus_type" type="text" class="form-control" name="employerstatus_type" value="{{ old('employerstatus_type') }}" required autofocus>

                                @if ($errors->has('employerstatus_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('employerstatus_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
