@extends('system-mgmt.country.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new country</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('country.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('country_name') ? ' has-error' : '' }}">
                            <label for="country_name" class="col-md-4 control-label">Country Name</label>

                            <div class="col-md-6">
                                <input id="country_name" type="text" class="form-control" name="country_name" value="{{ old('country_name') }}" required autofocus>

                                @if ($errors->has('country_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('country_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('country_code') ? ' has-error' : '' }}">
                            <label for="country_code" class="col-md-4 control-label">Country Code</label>

                            <div class="col-md-6">
                                <input id="country_code" type="text" class="form-control" name="country_code" value="{{ old('country_code') }}" required>
                                @if ($errors->has('country_code'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('country_code') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
