@extends('system-mgmt.companyprofile.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">Company Profile</h3>
        </div>
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('companyprofile.create') }}">Add Company Profile</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('companyprofile.search') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['Name'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['companyprofile_name'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="company_name: activate to sort column ascending">Company Name</th>
                <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="address: activate to sort column ascending">Address</th>
                <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="website: activate to sort column ascending">Website</th>
                <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email: activate to sort column ascending">Email</th>
                <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="telephone: activate to sort column ascending">Telephone</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
            @foreach ($companyprofile as $companyprofiles)
                <tr role="row" class="odd">
                  <td>{{ $companyprofiles->company_name }}</td>
                  <td>{{ $companyprofiles->address }}</td>
                  <td>{{ $companyprofiles->website }}</td>
                  <td>{{ $companyprofiles->email }}</td>
                  <td>{{ $companyprofiles->telephone }}</td>
                  <td>
                    <form class="row" method="POST" action="{{ route('companyprofile.destroy', $companyprofiles->id)}}" onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <a href="{{ route('companyprofile.edit', $companyprofiles->id)}}" class="btn btn-warning col-sm-10 col-xs-5 btn-margin">
                        Update
                        </a>
                        <button type="submit" class="btn btn-danger col-sm-10 col-xs-5 btn-margin">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
            @endforeach
            </tbody>
            <tfoot>
              <tr>
                <th width="30%" rowspan="1" colspan="1">Company Name</th>
                <th width="30%" rowspan="1" colspan="1">Address</th>
                <th width="30%" rowspan="1" colspan="1">Website</th>
                <th width="30%" rowspan="1" colspan="1">Email</th>
                <th width="30%" rowspan="1" colspan="1">Telephone</th>
                <th rowspan="1" colspan="2">Action</th>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($companyprofile)}} of {{count($companyprofile)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $companyprofile->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection