@extends('statistics.base')
@section('action-content')


    <!-- Main content -->
    <section class="content">
      <!-- Info boxes -->
      <div class="row">
        <div class="col-md-3 col-sm-10 col-xs-15">
          <div class="info-box">
            <div class="icon">
            <span class="info-box-icon bg-aqua"><i class="ion ion-person-add"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Registered</span>
              <span class="info-box-number">{{$total_clients}}<small></small></span>
              
              
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
      </div>
      
       <!-- fix for small devices only -->
        <div class="clearfix visible-sm-block"></div>

        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
            <span class="info-box-icon bg-green"><i class="ion ion-person-add"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">New Online Registered</span>
              <span class="info-box-number">{{$total_Nullclients}}</span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->

        <!-- /.col -->
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
            <span class="info-box-icon bg-red"><i class="ion-ios-people-outline"></i></span>

            <div class="info-box-content">
              <span class="info-box-text"></span>
              <span class="info-box-number">{{0}}<small></small></span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->

        <!-- fix for small devices only -->
        <div class="clearfix visible-sm-block"></div>
        <!-- /.col -->
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
            <span class="info-box-icon bg-yellow"><i class="ion ion-ios-people-outline"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Total Contributions</span>
              <span class="info-box-number">¢ {{ number_format(( sprintf(' %01.2f', $client_contribution) / 1), 2, '.', ',') }}</span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->
      </div>

      
       <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-6">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Product Members Count</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th style="width: 10px">#</th>
                      <th>Region</th>
                      <th>Progress</th>
                      <th style="width: 40px">Count</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>1.</td>
                      <td>HNI</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar progress-bar-red" style="width: 55%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-red">{{$fundtype1}}</span></td>
                    </tr>
                    <tr>
                      <td>2.</td>
                      <td>Ahomgye Pa</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar bg-blue" style="width: 70%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-blue">{{$fundtype2}}</span></td>
                    </tr>
                    <tr>
                      <td>3.</td>
                      <td>Collective Investment Scheme</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar bg-yellow" style="width: 70%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-yellow">{{$fundtype3}}</span></td>
                    </tr>
                    <tr>
                      <td>4.</td>
                      <td>Private Wealth Management</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar bg-blue" style="width: 70%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-blue">{{$fundtype4}}</span></td>
                    </tr>
                    <tr>
                      <td>5.</td>
                      <td>SIP</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar bg-orange" style="width: 70%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-orange">{{$fundtype5}}</span></td>
                    </tr>
                    <tr>
                      <td>6.</td>
                      <td>FIXED INCOME SECURITIES</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar bg-purple" style="width: 70%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-purple">{{$fundtype6}}</span></td>
                    </tr>
                    <tr>
                      <td>7.</td>
                      <td>Personal Investment Plan</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar bg-green" style="width: 70%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-green">{{$fundtype7}}</span></td>
                    </tr>
                    <tr>
                      <td>8.</td>
                      <td>Student Investment Account</td>
                      <td>
                        <div class="progress progress-xs">
                          <div class="progress-bar bg-black" style="width: 70%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-black">{{$fundtype8}}</span></td>
                    </tr>
                    <tr>
                  
                      <!--<td>3.</td>
                      <td>Cron job running</td>
                      <td>
                        <div class="progress progress-xs progress-striped active">
                          <div class="progress-bar bg-primary" style="width: 30%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-primary">30%</span></td>
                    </tr>
                    <tr>
                      <td>4.</td>
                      <td>Fix and squish bugs</td>
                      <td>
                        <div class="progress progress-xs progress-striped active">
                          <div class="progress-bar bg-success" style="width: 90%"></div>
                        </div>
                      </td>
                      <td><span class="badge bg-success">90%</span></td>
                    </tr>-->
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            </div>
            <!-- ./box-body -->
            <div class="box-footer">
              <div class="row">
                <div class="col-sm-3 col-xs-6">
                  <div class="description-block border-right">
                    <span class="description-percentage text-green"><i class="fa fa-caret-up"></i> {{0}}%</span>
                    <h5 class="description-header">{{$total_clients}}</h5>
                    <span class="description-text">TOTAL REGISTERED</span>
                  </div>
                  <!-- /.description-block -->
                </div>
                <!-- /.col -->
                <div class="col-sm-3 col-xs-6">
                  <div class="description-block border-right">
                    <span class="description-percentage text-yellow"><i class="fa fa-caret-left"></i> {{0}}%</span>
                    <h5 class="description-header">{{0}}</h5>
                    <span class="description-text">RETIREMENT / DEAD </span>
                  </div>
                  <!-- /.description-block -->
                </div>
                <!-- /.col -->
                <div class="col-sm-3 col-xs-6">
                  <div class="description-block border-right">
                    <span class="description-percentage text-green"><i class="fa fa-caret-up"></i> 0%</span>
                    <h5 class="description-header">¢{{$client_contribution}}</h5>
                    <span class="description-text">TOTAL CONTRIBUTION</span>
                  </div>
                  <!-- /.description-block -->
                </div>
                <!-- /.col -->
                <div class="col-sm-3 col-xs-6">
                  <div class="description-block">
                    <span class="description-percentage text-red"><i class="fa fa-caret-down"></i> 0%</span>
                    <h5 class="description-header">0</h5>
                    <span class="description-text">GOAL COMPLETIONS</span>
                  </div>
                  <!-- /.description-block -->
                </div>
                </div>
                <!-- /.active null list-block for students -->
              <div class="card">
              <div class="card-header border-0">
                <h3 class="card-title">Online New Registered Student List</h3>
              </div>
              <div class="card-body p-0">
                <table class="table table-striped table-valign-middle">
                  <thead>
                  <tr>
                    <th>Picture</th>
                    <th>Client Account Number</th>
                    <th>Staff Name</th>
                    <th>Gender</th>
                    <th>Investment Category</th>
                    <th>Active Status</th>
                  </tr>
                  </thead>
                  <tbody>
            @foreach ($studentkyc as $studentkycs)
    <tr role="row" class="odd">
    <td><img src="{{asset('storage/app/public/' .$studentkycs->passportpicture)}}" width="35px" height="35px"/></td>
    <td>{{$studentkycs->clientaccount_number}}</td>
    <td>{{$studentkycs->firstname}} {{$studentkycs->middlename}} {{$studentkycs->lastname}}</td>
    <td>{{$studentkycs->sex_type}}</td>
    <td>{{$studentkycs->fundtype_name}}</td>
    <td>
        <div class="btn-group text-right" id="button-{{$studentkycs->id}}">
            @if($studentkycs->active_id == 0)
            <button type="button" class="btn btn-info br2 btn-xs fs12 dropdown-toggle"
                    data-toggle="dropdown" aria-expanded="false"> Pending
                <span class="caret ml5"></span>
            </button>
            <ul class="dropdown-menu" role="menu">
                <li>
                    <a href="{{ route('studentkyc.edit', $studentkycs->id) }}"
                       class="approveClick" data-id="{{$studentkycs->id}}" data-name="Yes">Update</a>
                </li>
                <li>
                    <a href="{{ route('studentkyc.edit', $studentkycs->id) }}"
                       class="disapproveClick" data-id="{{$studentkycs->id}}" data-name="No">Delete</a>
                </li>
            </ul>
            @elseif($studentkycs->active_id == 2)
            <button type="button" class="btn btn-success br2 btn-xs fs12" aria-expanded="false">
                <i class="fa fa-check"> Approved </i>
            </button>
            @else
            <button type="button" class="btn btn-danger br2 btn-xs fs12" aria-expanded="false">
                <i class="fa fa-times"> Disapproved </i>
            </button>
            @endif
        </div>
    </td>
</tr>
@endforeach
            </tbody>
                </table>
              </div>
            </div>
            <!-- /.card -->
              <!-- /.active null list-block -->
              
          </div>
            <!-- /.box-footer -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
        
    <!-- /.content -->
  
  <!-- /.content-wrapper -->
  
<!-- ./wrapper -->

<!-- REQUIRED JS SCRIPTS -->

 <!-- jQuery 2.1.3 -->
<script src="{{ asset ('/bower_components/AdminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>

<!-- Bootstrap 3.3.2 JS -->
<script src="{{ asset ('/bower_components/AdminLTE/bootstrap/js/bootstrap.min.js') }}" type="text/javascript"></script>

<!-- AdminLTE App -->
<script src="{{ asset ('/bower_components/AdminLTE/dist/js/app.min.js') }}" type="text/javascript"></script>

<!-- Optionally, you can add Slimscroll and FastClick plugins.
     Both of these plugins are recommended to enhance the
     user experience. Slimscroll is required when using the
     fixed layout. -->

</body>
<script src="{{ asset('vendor/adminlte/vendor/jquery/dist/jquery.min.js') }}"></script>

<script src="{{ asset('vendor/adminlte/vendor/bootstrap/dist/js/bootstrap.min.js') }}"></script>

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE -->
<script src="dist/js/adminlte.js"></script>

<!-- OPTIONAL SCRIPTS -->
<script src="plugins/chart.js/Chart.min.js"></script>
<script src="dist/js/demo.js"></script>
<script src="dist/js/pages/dashboard3.js"></script>

</div>
</body>
</html>
@endsection