@extends('retirement-death.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Retirement / Dead List </div>
                @if (\Session::has('success'))
      <div class="alert alert-success">
        <p>{{ \Session::get('success') }}</p>
      </div><br />
     @endif
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('retirement-death.update', ['id' => $Retirement_death->id]) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('staff_no') ? ' has-error' : '' }}">
                            <label for="staff_no" class="col-md-4 control-label">Staff Number </label>

                            <div class="col-md-6">
                                <input id="staff_no" type="text" class="form-control" name="staff_no" value="{{ $Retirement_death->staff_no }}" required autofocus>

                                @if ($errors->has('staff_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('staff_no') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                            <label for="name" class="col-md-4 control-label">Name </label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control" name="name" value="{{ $Retirement_death->name }}" required autofocus>

                                @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('incident_date') ? ' has-error' : '' }}">
                            <label for="incident_date" class="col-md-4 control-label">Date Of Termination </label>

                            <div class="col-md-6">
                                 <div class="input-group date">
                                        <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                                </div>
                                <input id="incident_date" type="date" class="form-control" name="incident_date" value="{{ $Retirement_death->incident_date }}" required autofocus>

                                @if ($errors->has('incident_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('incident_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                         
                        <div class="form-group">
        <label class="col-md-4 control-label">Claim Type</label>
        <div class="col-md-6">
        <select class="form-control" name="claimtype_id">
        @foreach ($ClaimTypes as $ClaimType)
        <option {{$Retirement_death->claimtype_id == $ClaimType->id ? 'selected' : ''}} value="{{$ClaimType->id}}">{{$ClaimType->claimtype_name}}</option>
        @endforeach
        </select>
        </div>
        </div>
                        <div class="form-group{{ $errors->has('total_contribution') ? ' has-error' : '' }}">
                            <label for="total_contribution" class="col-md-4 control-label">Total Contribution </label>
                            <div class="col-md-6">
                                <input id="total_contribution" type="text" class="form-control" name="total_contribution" value="{{ $Retirement_death->total_contribution }}" readonly>

                                @if ($errors->has('total_contribution'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('total_contribution') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
        <label class="col-md-4 control-label">Interest Amount</label>
        <div class="col-md-6">
        <select class="form-control" name="interests_id">
        @foreach ($interest as $interests)
        <option {{$Retirement_death->interests_id == $interests->id ? 'selected' : ''}} value="{{$interests->id}}">{{$interests->interest_amount}}</option>
        @endforeach
        </select>
        </div>
        </div>
        <div class="form-group{{ $errors->has('tc_dot_amount') ? ' has-error' : '' }}">
                            <label for="tc_dot_amount" class="col-md-4 control-label">Contributed Amount As At Termination </label>
                            <div class="col-md-6">
                                <input id="tc_dot_amount" type="text" class="form-control" name="tc_dot_amount" value="{{ $Retirement_death->tc_dot_amount }}" required autofocus>

                                @if ($errors->has('tc_dot_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('tc_dot_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('benefit_amount') ? ' has-error' : '' }}">
                            <label for="benefit_amount" class="col-md-4 control-label">Benefit Amount To Be Paid </label>
                            <div class="col-md-6">
                                <input id="benefit_amount" type="text" class="form-control" name="benefit_amount" value="{{ $Retirement_death->benefit_amount }}" readonly>

                                @if ($errors->has('benefit_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('benefit_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('amount_paid') ? ' has-error' : '' }}">
                            <label for="amount_paid" class="col-md-4 control-label">Amount Paid </label>
                            <div class="col-md-6">
                                <input id="amount_paid" type="text" class="form-control" name="amount_paid" value="{{ $Retirement_death->amount_paid }}" nullable>

                                @if ($errors->has('amount_paid'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount_paid') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('balance_amount') ? ' has-error' : '' }}">
                            <label for="balance_amount" class="col-md-4 control-label">Balance On Contribution Amount </label>
                            <div class="col-md-6">
                                <input id="balance_amount" type="text" class="form-control" name="balance_amount" value="{{ $Retirement_death->balance_amount }}" readonly>

                                @if ($errors->has('balance_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('balance_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('comment') ? ' has-error' : '' }}">
                            <label for="comment" class="col-md-4 control-label">Comment </label>
                            <div class="col-md-6">
                                <input id="comment" type="text" class="form-control" name="comment" value="{{ $Retirement_death->comment }}" required autofocus>

                                @if ($errors->has('comment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('comment') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection