@extends('retirement-death.base')

@section('action-content')
<!DOCTYPE html>
<html>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
<link href="https://fonts.googleapis.com/css?family=Raleway" rel="stylesheet">
<script src="jquery.js"></script>
<script src="{{asset('js/bootstrap.js')}}"></script>

<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Retired / Dead Client</div>
                @if (\Session::has('success'))
      <div class="alert alert-success">
        <p>{{ \Session::get('success') }}</p>
      </div><br />
     @endif


                <div class="panel-body">
                    <form  class="form-horizontal" method="POST" action="{{ url('retirement-death/search') }}">
                        {{csrf_field()}}
                             @component('layouts.search', ['title' => 'Search'])
                              @component('layouts.two-cols-search-row', ['items' => ['staff_number'], 
                              
                              'oldVals' => [isset($searchingVals) ? $searchingVals['staff_no'] : '']])

                              @endcomponent
                            @endcomponent


                    </form>
                    

                @if(isset($employee))
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('retirement-death.store') }}">
                        {{ csrf_field() }}
                        <div class="form-group">
                           
                        {{csrf_field()}}   
                       
        
                  <div class="form-group{{ $errors->has('staff_number') ? ' has-error' : '' }}">
                            <label for="staff_number" class="col-md-4 control-label">Staff Number</label>
                            <div class="col-md-6">
                                <input id="staff_number" type="text" class="form-control" name="staff_number" value="{{ $employee->staff_number }}" readonly="">
                                 <span id="availabilty" class="text-danger"></span>

                                @if ($errors->has('staff_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('staff_number') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                            <label for="name" class="col-md-4 control-label">Client Name</label>
                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control" name="name" value="{{ $employee->firstname }} {{ $employee->middlename }} {{ $employee->lastname }}" readonly>
                                @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label class="col-md-4 control-label">Claim Type</label>
                            <div class="col-md-6">
                                <select class="form-control" name="claimtype_id">
                                    <option value="-1">Please select claim type</option>
                                    @foreach ($ClaimTypes as $ClaimType)
                                        <option value="{{$ClaimType->id}}" >{{$ClaimType->claimtype_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('sum') ? ' has-error' : '' }}">
                            <label for="sum" class="col-md-4 control-label">Total Contribution</label>
                            <div class="col-md-6">
                                <input id="sum" type="text" class="form-control" name="sum" value="{{$sum}}" readonly>

                                @if ($errors->has('sum'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sum') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Interest Amount</label>
                            <div class="col-md-6">
                                <select class="form-control" name="interests_id">
                                    <option value="-1">Please select Interest Amount</option>
                                    @foreach ($interest as $interests)
                                        <option value="{{$interests->id}}">{{$interests->interest_amount}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Date Of Termination</label>
                            <div class="col-md-6">
                                <div class="input-group date">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <input type="date" value="{{ old('incident_date') }}"
                                    name="incident_date"class="form-control pull-right"
                                    id="incident_date" required>
                                </div>
                            </div>
                        </div>
        <div class="form-group{{ $errors->has('tc_dot_amount  ') ? ' has-error' : '' }}">
                            <label for="tc_dot_amount" class="col-md-4 control-label">Contributed Amount As At Termination </label>
                            <div class="col-md-6">
                                <input id="tc_dot_amount" type="text" class="form-control" name="tc_dot_amount" value="{{ old('tc_dot_amount  ') }}" >

                                @if ($errors->has('tc_dot_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('tc_dot_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('benefit_amount  ') ? ' has-error' : '' }}">
                            <label for="benefit_amount" class="col-md-4 control-label">Benefit Amount To Be Paid </label>
                            <div class="col-md-6">
                                <input id="benefit_amount" type="text" class="form-control" name="benefit_amount" value="{{ old('benefit_amount  ') }}" readonly>

                                @if ($errors->has('benefit_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('benefit_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('amount_paid') ? ' has-error' : '' }}">
                            <label for="amount_paid" class="col-md-4 control-label">Amount Paid </label>
                            <div class="col-md-6">
                                <input id="amount_paid" type="text" class="form-control" name="amount_paid" value="{{ old('amount_paid  ') }}" nullable>

                                @if ($errors->has('amount_paid'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount_paid') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('balance_amount  ') ? ' has-error' : '' }}">
                            <label for="balance_amount" class="col-md-4 control-label">Balance On Contribution Amount  </label>
                            <div class="col-md-6">
                                <input id="balance_amount" type="text" class="form-control" name="balance_amount" value="{{ old('balance_amount  ') }}" readonly>

                                @if ($errors->has('balance_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('balance_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('comment') ? ' has-error' : '' }}">
                        <label for="comment" class="col-md-4 control-label">Comments</label>
                        <div class="col-md-6">
                        <textarea class="form-control" rows="3" placeholder="Enter ..." name="comment"></textarea>
                        </div>
                        </div> 
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>


  
@endsection

@section('my-scripts')
  <script type="text/javascript">
   $('#staff_number').keyup(function(){
    var inputValue = $(this).val();

    if(inputValue === ''){
      return
    }

    var url = "{{url('/check-if-staff-no-exists')}}" + "/" + inputValue;
  
  // ajax request

    $.get(url, function(result){
          if (result.status === true) {
              // staff id exists
              $('#availabilty').html('Staff Id already exists');
          }else{
            $('#availabilty').html('')
          }
    });

   });
  </script>
@endsection


  




