@extends('reports/rtpemployee.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">Employee Details Report</h3>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('rtpemployee.excel') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['firstname']}}" name="firstname" />
                <input type="hidden" value="{{$searchingVals['staff_number']}}" name="staff_number" />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('rtpemployee.pdf') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['firstname']}}" name="firstname" />
                <input type="hidden" value="{{$searchingVals['staff_number']}}" name="staff_number" />
                <button type="submit" class="btn btn-info">
                  Export to PDF
                </button>
            </form>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('rtpemployee.search') }}">
         {{ csrf_field() }}
          @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['Firstname', 'staff_number'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['firstname'] : '', isset($searchingVals) ? $searchingVals['staff_number'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="table-responsive">
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Picture: activate to sort column descending" aria-sort="ascending">Picture</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_number: activate to sort column ascending">Staff Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="sex: activate to sort column ascending">Gender</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name_of_school: activate to sort column ascending">Name Of School</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Address_of_school: activate to sort column ascending">Address Of School</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country: activate to sort column ascending">Country</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="state: activate to sort column ascending">Region</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="district: activate to sort column ascending">District</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Birthdate: activate to sort column ascending">Birthdate</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Age: activate to sort column ascending">Age</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Department: activate to sort column ascending">ID Type</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="id_number: activate to sort column ascending">ID Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Division: activate to sort column ascending">Marital Status</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="mobile_number: activate to sort column ascending">Mobile Number</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address: activate to sort column ascending">Email Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="bank_name: activate to sort column ascending">Bank Name</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="branch_name: activate to sort column ascending">Branch Name</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="account_number: activate to sort column ascending">Account Number</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: ">Active Type</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
            @foreach ($employees as $employee)
                <tr role="row" class="odd">
                  <td> <a href="{{url('other-employee-details/nextofkin')}}"> <img src="../{{$employee->picture}}" width="60px" height="60px"/></a></td>
                  <td class="hidden-xs">{{ $employee->staff_number }}</td>
                  <td class="sorting_1"><a href="{{url('other-employee-details/nextofkin/'.$employee->id)}}">{{ $employee->firstname }} {{$employee->middlename}} {{$employee->lastname}}</a> </td>
                  <td class="hidden-xs">{{ $employee->sex_type }}</td>
                  <td class="hidden-xs">{{ $employee->fundtype_name }}</td>
                  <td class="hidden-xs">{{ $employee->name_of_school }}</td>
                  <td class="hidden-xs">{{ $employee->address_of_school }}</td>
                  <td class="hidden-xs">{{ $employee->country_name }}</td>
                  <td class="hidden-xs">{{ $employee->state_name }}</td>
                  <td class="hidden-xs">{{ $employee->district }}</td>
                  <td class="hidden-xs">{{ $employee->birthdate }}</td>
                  <td class="hidden-xs">{{ \Carbon\Carbon::parse($employee->birthdate)->age }}</td>
                  <td class="hidden-xs">{{ $employee->department_name }}</td>
                  <td class="hidden-xs">{{ $employee->id_number }}</td>
                  <td class="hidden-xs">{{ $employee->division_name }}</td>
                  <td class="hidden-xs">{{ $employee->phone_number }}</td>
                  <td class="hidden-xs">{{ $employee->mobile_number }}</td>
                  <td class="hidden-xs">{{ $employee->email_address }}</td>
                  <td class="hidden-xs">{{ $employee->bank_name }}</td>
                  <td class="hidden-xs">{{ $employee->branch_name }}</td>
                  <td class="hidden-xs">{{ $employee->account_number }}</td>
                  <td class="hidden-xs">{{ $employee->active_type }}</td>
                  <td>
                    <form class="row" method="POST" action="{{ route('employee-management.destroy', ['id' => $employee->id]) }}" onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <a href="{{ route('employee-management.edit', ['id' => $employee->id]) }}" class="glyphicon glyphicon-pencil btn-warning col-sm-10 col-xs-10 btn-margin">
                        Update
                        </a>
                         <button type="submit" class="glyphicon glyphicon-trash btn-danger col-sm-10 col-xs-10 btn-margin">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
            @endforeach
            </tbody>
            <tfoot>
              <tr>
                <tr role="row">
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Picture: activate to sort column descending" aria-sort="ascending">Picture</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_number: activate to sort column ascending">Staff Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="sex: activate to sort column ascending">Gender</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name_of_school: activate to sort column ascending">Name Of School</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Address_of_school: activate to sort column ascending">Address Of School</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country: activate to sort column ascending">Country</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="state: activate to sort column ascending">Region</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="district: activate to sort column ascending">District</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Birthdate: activate to sort column ascending">Birthdate</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Age: activate to sort column ascending">Age</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Department: activate to sort column ascending">ID Type</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="id_number: activate to sort column ascending">ID Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Division: activate to sort column ascending">Marital Status</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="mobile_number: activate to sort column ascending">Mobile Number</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address: activate to sort column ascending">Email Address</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="bank_name: activate to sort column ascending">Bank Name</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="branch_name: activate to sort column ascending">Branch Name</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="account_number: activate to sort column ascending">Account Number</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: activate to sort column ascending">Active Type</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($employees)}} of {{count($employees)}} entries</div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection