@extends('reports.rptfund.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">Client List by Fund Type Report</h3>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('rptfund.excel') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['fundtype_name']}}" name="fundtype_id" />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('rptfund.pdf') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['fundtype_name']}}" name="fundtype_id" />
                <button type="submit" class="btn btn-info">
                  Export to PDF
                </button>
            </form>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('rptfund.search') }}">
         {{ csrf_field() }}
        <div class="row">
             <div class="col-md-6">
              <label> Select Fund Type </label>
               <select class="form-control" name="fundtype_id">
                <option value="-1">Please select Fund Type</option>
                
                @foreach($fundtype as $fundtypes)
                      <option value="{{$fundtypes->id}}"> {{$fundtypes->fundtype_name}}</option>
                 @endforeach 
              </select>           

             </div>
             <div class="col-md-6">
              
             </div>
           </div>
           <br>
            <button class="btn btn-primary" type="submit">Search</button>

            <hr>
        </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="table-responsive">
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Picture: activate to sort column descending" aria-sort="ascending">Picture</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="sex: activate to sort column ascending">Sex</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country: activate to sort column ascending">Country</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Birthdate: activate to sort column ascending">Birthdate</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="age: activate to sort column ascending">Age</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="department: activate to sort column ascending">ID Type</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="id_number: activate to sort column ascending">ID Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address_contact: activate to sort column ascending">Email Address</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total: activate to sort column ascending">Total Contribution</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: ">Active Type</th>
              </tr>
            </thead>
            <tbody>
            @foreach ($studentkyc as $studentkycs)
                <tr role="row" class="odd">
                  <td><img src="{{asset('storage/app/' .$studentkycs->passportpicture)}}" width="50px" height="50px"/></td>
                  <td class="hidden-xs">{{ $studentkycs->clientaccount_number }}</td>
                  <td class="sorting_1">{{ $studentkycs->firstname }} {{$studentkycs->middlename}} {{$studentkycs->lastname}}</td>
                  <td class="hidden-xs">{{ $studentkycs->sex->sex_type ?? '' }}</td>
                  <td class="hidden-xs">{{ $studentkycs->fundtype->fundtype_name ?? '' }}</td>
                  <td class="hidden-xs">{{ $studentkycs->country->country_name ?? ''}}</td>
                  <td class="hidden-xs">{{ $studentkycs->birthdate }}</td>
                  <td class="hidden-xs">{{ \Carbon\Carbon::parse($studentkycs->birthdate)->age }}</td>
                  <td class="hidden-xs">{{ $studentkycs->identificationtype->identification_type ?? ''}}</td>
                  <td class="hidden-xs">{{ $studentkycs->identification_number ?? ''}}</td>
                  <td class="hidden-xs">{{ $studentkycs->phone_number ?? ''}}</td>
                  <td class="hidden-xs">{{ $studentkycs->email_address_contact ?? ''}}</td>
                   <td class="hidden-xs">{{ $studentkycs->clientContributions()->sum('contribution_amount') }}</td>
                  <td class="hidden-xs">{{ $studentkycs->active->active_type ?? ''}}</td>
                    </tr>
            @endforeach
            </tbody>
            <tfoot>
              <tr>
                <tr role="row">
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Picture: activate to sort column descending" aria-sort="ascending">Picture</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="sex: activate to sort column ascending">Sex</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country: activate to sort column ascending">Country</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Birthdate: activate to sort column ascending">Birthdate</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="age: activate to sort column ascending">Age</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="department: activate to sort column ascending">ID Type</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="id_number: activate to sort column ascending">ID Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address_contact: activate to sort column ascending">Email Address</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total: activate to sort column ascending">Total Contribution</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: ">Active Type</th>
              </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection