@extends('reports.onlineclient.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">List Of All Clients Report</h3>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('onlineclient.excel') }}">
              {{ csrf_field() }}
              <input type="hidden" value="{{$searchingVals['from']}}" name="from" />
                <input type="hidden" value="{{$searchingVals['to']}}" name="to" />
                <input type="hidden" value="{{$searchingVals['active_type']}}" name="active_id" />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('onlineclient.pdf') }}">
              {{ csrf_field() }}
              <input type="hidden" value="{{$searchingVals['from']}}" name="from" />
                <input type="hidden" value="{{$searchingVals['to']}}" name="to" />
                <input type="hidden" value="{{$searchingVals['active_type']}}" name="active_id" />
                <button type="submit" class="btn btn-info">
                  Export to PDF
                </button>
            </form>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('onlineclient.search') }}">
         {{ csrf_field() }}
         <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      @component('layouts.two-cols-date-search-row', ['items' => ['From', 'To'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['from'] : '', isset($searchingVals) ? $searchingVals['to'] : '']])
          @endcomponent
        <br>
        <div class="row">
             <div class="col-md-4">
              <label> Select Active Status Type </label>
               <select class="form-control" name="active_id">
                <option value="-1">Please select Status</option>
                @foreach($active as $actives)
      <option value="{{$actives->id}}"> {{$actives->active_type}}</option>
                  @endforeach
                 
                        </select>
                      </div>
             <div class="col-md-6">
              
             </div>
           </div>

      
           <br>
            <button class="btn btn-primary" type="submit">Search</button>

            <hr>

        
        </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="table-responsive">
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="passportPicture: activate to sort column descending" aria-sort="ascending">Picture</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="PictureID: activate to sort column descending" aria-sort="ascending">ID Picture</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="signature_upload: activate to sort column descending" aria-sort="ascending">Signature Upload</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Staff Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="sex: activate to sort column ascending">Sex</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country: activate to sort column ascending">Country</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Birthdate: activate to sort column ascending">Birthdate</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Age: activate to sort column ascending">Age</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="indentificationtype: activate to sort column ascending">Identification Type</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="identificationtype: activate to sort column ascending">Identification Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address_contact: activate to sort column ascending">Email Address</th>
                <th width="16%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: activate to sort column ascending">Active</th>
                <th width="16%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="created_at: activate to sort column ascending">Created Date</th>
                
              </tr>
            </thead>
            <tbody>
            @foreach ($employees as $employee)
                <tr role="row" class="odd">
                  <td><img src="/Assetmgt/{{$employee->passportpicture }}" width="50px" height="50px"/></td>
                  <td> <img src="/Assetmgt/{{$employee->pictureID}}" width="60px" height="60px"/></a></td>
                  <td> <img src="/Assetmgt/{{$employee->signature_upload}}" width="60px" height="60px"/></a></td>
                  <td class="hidden-xs">{{ $employee->clientaccount_number }}</td>
                  <td class="sorting_1">{{ $employee->firstname }} {{$employee->middlename}} {{$employee->lastname}}</td>
                  <td class="hidden-xs">{{ $employee->sex->sex_type }}</td>
                  <td class="hidden-xs">{{ $employee->fundtype->fundtype_name }}</td>
                  <td class="hidden-xs">{{ $employee->country->country_name }}</td>
                  <td class="hidden-xs">{{ $employee->birthdate }}</td>
                  <td class="hidden-xs">{{ \Carbon\Carbon::parse($employee->birthdate)->age }}</td>
                  <td class="hidden-xs">{{ $employee->identificationtype->identification_type }}</td>
                  <td class="hidden-xs">{{ $employee->identification_number }}</td>
                  <td class="hidden-xs">{{ $employee->phone_number }}</td>
                  <td class="hidden-xs">{{ $employee->email_address_contact }}</td>
                  <td class="hidden-xs">{{ $employee->active->active_type }}</td>
                  <td class="hidden-xs">{{ $employee->created_at }}</td>
                  
                  
                    </tr>
            @endforeach
            </tbody>
            <tfoot>
              <tr>
                <tr role="row">
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="passportPicture: activate to sort column descending" aria-sort="ascending">Picture</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="PictureID: activate to sort column descending" aria-sort="ascending">ID Picture</th>
                <th width="10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="signature_upload: activate to sort column descending" aria-sort="ascending">Signature Upload</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Staff Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="sex: activate to sort column ascending">Sex</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="country: activate to sort column ascending">Country</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Birthdate: activate to sort column ascending">Birthdate</th>
                <th width="5%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Age: activate to sort column ascending">Age</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="indentificationtype: activate to sort column ascending">Identification Type</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="identificationtype: activate to sort column ascending">Identification Number</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="phone_number: activate to sort column ascending">Phone Number</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="email_address_contact: activate to sort column ascending">Email Address</th>
                <th width="16%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="active: activate to sort column ascending">Active</th>
                <th width="16%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="created_at: activate to sort column ascending">Created Date</th>
                
              </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($employees)}} of {{count($employees)}} entries</div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection