@extends('reports.individualclientdailyint.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">Individual Client Daily Interest And Contributions Report</h3>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('individualclientdailyint.excel') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['clientaccount_number']}}" name="clientaccount_number" />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">

           
          
                <form class="form-horizontal" role="form" method="POST" action="{{ route('individualclientdailyint.pdf') }}">
                  {{ csrf_field() }}
                    <input type="hidden" value="{{$searchingVals['clientaccount_number']}}" name="clientaccount_number" />
                    <button type="submit" class="btn btn-info">
                      Export to PDF
                    </button>
                </form>
              
           
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('individualclientdailyint.search') }}">
         {{ csrf_field() }}
           @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['clientaccount_number'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['clientaccount_number'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="table-responsive">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Year</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="transaction_type: activate to sort column ascending">Transaction Type</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest_rate: activate to sort column ascending">Interest Rate %</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interestonmaturity_amount: activate to sort column ascending">Accrued Interest Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="maturityvalue_amount: activate to sort column ascending">Accrued Maturity Value Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="narration: activate to sort column ascending">Narration</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="incident_date: activate to sort column ascending">Date of Transaction</th>
              </tr>
            </thead>
            <tbody>
         
             @if($Dailyinterestcalculator)
               @foreach ($Dailyinterestcalculator as $Dailyinterestcalculators)
                  <tr role="row" class="odd">
                    <td>{{ $Dailyinterestcalculators->clientaccount_number }}</td>
                    <td>{{ $Dailyinterestcalculators->name }}</td>
                    <td>{{ $Dailyinterestcalculators->contribution_amount }}</td>
                    <td>{{ $Dailyinterestcalculators->contribution_month }}</td>
                    <td>{{ $Dailyinterestcalculators->year }}</td>
                    <td>{{ $Dailyinterestcalculators->transaction->transaction_type ?? '' }} </td>
                    <td>{{ $Dailyinterestcalculators->interest_rate}}</td>
                    <td>{{ $Dailyinterestcalculators->interestonmaturity_amount}}</td>
                    <td>{{ $Dailyinterestcalculators->maturityvalue_amount}}</td>
                    <td>{{ $Dailyinterestcalculators->narration}}</td>
                    <td>{{ $Dailyinterestcalculators->incident_date}}</td>
                    <tr>
                </tr>
              @endforeach
            @endif
          
            </tbody>
            <tfoot>
              <tr>
                <th colspan="7">Total</th>
                    <th id="total1">{{$total1}}</th>
                    <th colspan="8">{{$total}}</th>
                    
                  </tr> 
                  <tr>
                  <th colspan="2">Total Contribution</th>
                    <th id="total2">{{$total2}}</th>
                    
                    
                  </tr> 
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-12">
          @if($Dailyinterestcalculator)
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to 
          {{count($Dailyinterestcalculator)}} of {{count($Dailyinterestcalculator)}} entries</div>
          @endif
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection