@extends('reports.fundtyperpt-report.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">List Of Clients Report By Fund</h3>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('fundtyperpt-report.excel') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['fundtype_name']}}" name="state_id" />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('fundtyperpt-report.pdf') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['fundtype_name']}}" name="state_id" />
                <button type="submit" class="btn btn-info">
                  Export to PDF
                </button>
            </form>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('fundtyperpt-report.search') }}">
          {{csrf_field()}}
           <div class="row">
             <div class="col-md-6">
              <label> Select Type of Fund </label>
               <select class="form-control" name="fundtypes_id">
                <option value="-1">Please select Fund</option>
                
                @foreach($fundtype as $fundtypes)
                      <option value="{{$fundtypes->id}}"> {{$fundtypes->fundtype_name}}</option>
                    
                 @endforeach 
              </select>           

             </div>
             <div class="col-md-6">
              
             </div>
           </div>
           <br>
            <button class="btn btn-primary" type="submit">Search</button>

            <hr>

      </form>

    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">

            @if($client_contribution)
               @foreach ($client_contribution as $cl)

               @php
                $clientaccount_number = $cl->clientaccount_number;
                $employee = \App\Employee::where('clientaccount_number', $clientaccount_number)->first();

               @endphp

                @if($employee->active_id == 2)

                  <div class="box box-widget">

                   <table class="table table-striped table-hover">
                    <tr>
                      <td>
                          Client Account  Number
                      </td>
                      <td>
                        {{ $cl->clientaccount_number }}
                      </td>
                    </tr>
                    <tr>
                      <td>
                          Client Name
                      </td>
                      <td>
                        {{ $cl->firstname }} {{ $cl->middlename }} {{ $cl->lastname }}
                      </td>
                    </tr>
                  </table>

                  <p class="text-success"> Details of   {{ $cl->firstname }} {{ $cl->middlename }} {{ $cl->lastname }}'s contribution </p>
          
                      <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
                          <thead>
                            <tr role="row">
                              <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_no: activate to sort column ascending">Contribution Year</th>
                              <th width="25%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Contribution Month</th>
                              <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
                            </tr>
                          </thead>
                          <tbody>
                       <?php $sum = 0 ?>
                           @foreach($cl->clientContributions as $contribution)

                            <tr>
                              <td>
                               {{$contribution->year}}
                              </td>
                              <td>
                               {{ $contribution->contribution_month }}
                              </td>
                              <td>
                                {{ $contribution->contribution_amount }}
                              </td>
                            </tr>
                            <?php $contribution = $contribution->contribution_amount ? $contribution->contribution_amount : 0;

        $sum = $sum + $contribution;

       ?>
                           @endforeach
                          </tbody>
                <tr>
                <th colspan="2">Total</th>
                <th id="total">{{$sum}}</th>
                  </tr> 
                         
                        </table>
               </div>
               <br>

                @endif
               
               @endforeach
            @endif
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
          @if($fundtype)
         
          @endif
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection