@extends('reports.clientrptview.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">My Contributions Report</h3>
        </div>
        
        <div class="col-sm-4">

           @if($client_contribution)
              @php
                $staff_no = $client_contribution[0]->staff_no;
                $employee = \App\Employee::where('staff_number', $staff_no)->first();
              @endphp
          
                <form class="form-horizontal" role="form" method="POST" action="{{ route('clientrptview.pdf') }}">
                  {{ csrf_field() }}
                    <input type="hidden" value="{{$searchingVals['staff_no']}}" name="staff_no" />
                    <button type="submit" class="btn btn-info">
                      Export to PDF
                    </button>
                </form>
              @endif
           
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('clientrptview.search') }}">
         {{ csrf_field() }}
         <div class="row">
             <div class="col-md-6">
              <label> Select Staff Number </label>
               <select class="form-control" name="staff_no">
              
               @foreach($employee as $employees)
               @if( Auth::user()->staff_number == $employees->staff_number )
               <option value="{{$user->staff_number}}"> {{$employees->staff_number}}</option>
               @endif
               @endforeach
               
              
               
                 
                
              </select>           

             </div>
             <div class="col-md-6">
              
             </div>
           </div>
           <br>
            <button class="btn btn-primary" type="submit">Search</button>

            <hr>
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_no: activate to sort column ascending">Staff Number</th>
                <th width="25%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Name</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="7%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Contribution Year</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
              </tr>
            </thead>
            <tbody>
         
             @if($client_contribution)
               @foreach ($client_contribution as $client_contributions)
                  <tr role="row" class="odd">
                    <td>{{ $client_contributions->staff_no }}</td>
                    <td>{{ $client_contributions->name }}</td>
                    <td>{{ $client_contributions->contribution_month }}</td>
                    <td>{{ $client_contributions->year }}</td>
                    <td>{{ $client_contributions->contribution_amount }}</td>
                    <tr>
                </tr>
              @endforeach
            @endif
          
            </tbody>
            <tfoot>
              <tr>
                <th colspan="4">Total</th>
                    <th id="total">{{$total}}</th>
                  </tr>   
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
          @if($client_contribution)
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to 
          {{count($client_contribution)}} of {{count($client_contribution)}} entries</div>
          @endif
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection