@extends('oldretirement.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">List Of Old Retired Members</h3>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('oldretirement.search') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['staff_no'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['staff_no'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
              <th width="10%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_no: activate to sort column ascending">Staff Number</th>
              <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Name</th>
              <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="claimtype: activate to sort column ascending">Claim Type</th>
              <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="incident_date: activate to sort column ascending">Incident Date</th>
              <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_contribution: activate to sort column ascending">Total Contribution</th>
              <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="benefit_amount: activate to sort column ascending">Benefit Amount</th>
              </tr>
            </thead>
            <tbody>
            @foreach ($oldretirement as $oldretirements)
                <tr role="row" class="odd">
                  <td>{{ $oldretirements->staff_no }}</td>
                  <td>{{ $oldretirements->name }}</td>
                  <td>{{ $oldretirements->claimtype }}</td>
                  <td>{{ $oldretirements->incident_date }}</td>
                  <td>{{ $oldretirements->total_contribution }}</td>
                  <td>{{ $oldretirements->benefit_amount }}</td>
                  
              </tr>
            @endforeach
            </tbody>
          </table>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($oldretirement)}} of {{count($oldretirement)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $oldretirement->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection