@extends('newinvestment.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">List of Clients Investments</h3>
        </div>
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('newinvestment.create') }}">Create New Client Investment</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('newinvestment.search_1') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['clientaccount_number'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['clientaccount_number'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="table-responsive">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="incident_date: activate to sort column ascending">Date Of Booking</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_contribution: activate to sort column ascending">Total Contribution</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest: activate to sort column ascending">Interest Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="tc_dot_amount: activate to sort column ascending">Contributed Amount As At Termination</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="banefit_amount: activate to sort column ascending">Benefit Amount To Be Paid</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="amount_paid: activate to sort column ascending">Amount Paid</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="balance_amount: activate to sort column ascending">Balance On Contribution Amount</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="comment: activate to sort column ascending">Comment</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
               @foreach ($Investmentmodel as $Investmentmodels)
               <tr role="row" class="odd">
                  <td class="hidden-xs">{{ $Investmentmodels->clientaccount_number}}</td>
                  <td class="hidden-xs">{{ $Investmentmodels->name}}</td>
                  <td class="hidden-xs">{{ $Investmentmodels->incident_date}}</td>
                  <td class="hidden-xs">{{ $Investmentmodels->claimtype_name}}</td>
                  <td class="hidden-xs">{{ $Investmentmodels->total_contribution}}</td>
                  
                  <td>
                  <form class="row" method="POST" action="{{ route('newinvestment.destroy', ['id' => $Investmentmodels->id]) }}" onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <a href="{{ route('newinvestment.edit', ['id' => $Investmentmodels->id]) }}" class="glyphicon glyphicon-pencil btn-warning col-sm-10 col-xs-10 btn-margin">
                        Update
                        </a>
                        <button type="submit" class="glyphicon glyphicon-trash btn-danger col-sm-10 col-xs-10 btn-margin">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
              @endforeach
            </tbody>
            <tfoot>
              <tr>
                <tr role="row">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="incident_date: activate to sort column ascending">Date Of Booking</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="fundtype: activate to sort column ascending">Fund Type</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_contribution: activate to sort column ascending">Total Contribution</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest: activate to sort column ascending">Interest Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="tc_dot_amount: activate to sort column ascending">Contributed Amount As At Termination</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="banefit_amount: activate to sort column ascending">Benefit Amount To Be Paid</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="amount_paid: activate to sort column ascending">Amount Paid</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="balance_amount: activate to sort column ascending">Balance On Contribution Amount</th>
                <th width="18%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="comment: activate to sort column ascending">Comment</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($Investmentmodel)}} of {{count($Investmentmodel)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $Investmentmodel->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection