@extends('monthlyint.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">Monthly Interest Calculation</h3>
        </div>
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('monthlyint.create') }}">Calculate Monthly Interest</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('monthlyint.search_1') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['clientaccount_number'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['clientaccount_number'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="table-responsive">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Year</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="transaction_type: activate to sort column ascending">Transaction Type</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest: activate to sort column ascending">Interest %</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest_accrued: activate to sort column ascending">Interest Accrued</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_amount: activate to sort column ascending">Total Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="narration: activate to sort column ascending">Narration</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="incident_date: activate to sort column ascending">Date of Transaction</th>
              </tr>
              </tr>
            </thead>
            <tbody>
               @foreach ($Monthlyint as $Monthlyints)
               <tr role="row" class="odd">
                  <td class="hidden-xs">{{ $Monthlyints->clientaccount_number}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->name}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->contribution_amount}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->contribution_month}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->year}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->transaction_type}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->interest}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->interest_accrued}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->total_amount}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->narration}}</td>
                  <td class="hidden-xs">{{ $Monthlyints->incident_date}}</td>
                  <td>
                  <form class="row" method="POST" action="{{ route('monthlyint.destroy', $Monthlyints->id) }}"onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <a href="{{ route('monthlyint.edit', $Monthlyints->id) }}" class="glyphicon glyphicon-pencil btn-warning col-sm-8 col-xs-5 btn-margin">
                        Edit
                        </a>
                        <button type="submit" class="glyphicon glyphicon-trash btn-danger col-sm-8 col-xs-5 btn-margin">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
              @endforeach
            </tbody>
            <tfoot>
              <tr>
                <tr role="row">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Year</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="transaction_type: activate to sort column ascending">Transaction Type</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest: activate to sort column ascending">Interest %</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest_accrued: activate to sort column ascending">Interest Accrued</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_amount: activate to sort column ascending">Total Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="narration: activate to sort column ascending">Narration</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="incident_date: activate to sort column ascending">Date of Transaction</th>
              </tr>
              </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($Monthlyint)}} of {{count($Monthlyint)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $Monthlyint->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection