@extends('leave_request_form.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">Leave Request Form</h3>
        </div>
        @if($message = Session::get('success'))
        <div class="alert alert-success">
          <p>{{$message}}</p>
        </div>
        @endif
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('leave_request_form.create') }}">Add new leave request</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('leave_request_form.search') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['Firstname'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['firstname'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_ID: activate to sort column ascending">Staff ID</th>
                <th width="12%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Employee Name</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Department: activate to sort column ascending">Department</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_leave_days: activate to sort column ascending">Total leave Days</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="start_leave_date: activate to sort column ascending">Start Leave Date</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="end_leave_date: activate to sort column ascending">End Leave Date</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_requested: activate to sort column ascending">Leave Days Requested</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="outstanding_leave_days: activate to sort column ascending">Outstanding Leave Days</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
            @foreach($leave_request_form as $leave_request_forms)
                <tr role="row" class="odd">
                  <td>{{$leave_request_forms->staff_ID}}</td>
                  <td class="sorting_1">{{ $leave_request_forms->firstname }} {{$leave_request_forms->middlename}} {{$leave_request_forms->lastname}}</td>
                  <td>{{$leave_request_forms->department}}</td>
                  <td>{{$leave_request_forms->total_leave_days}}</td>
                  <td>{{$leave_request_forms->start_leave_date}}</td>
                  <td>{{$leave_request_forms->end_leave_date}}</td>
                  <td>{{$leave_request_forms->leave_days_requested}}</td>
                  <td>{{$leave_request_forms->outstanding_leave_days}}</td>
                  <td>
                        <a href="{{action('LRequestController@edit', ['id'])}}" class="btn btn-warning col-sm-3 col-xs-5 btn-margin">
                        Edit
                        </a>
                         <button type="submit" class="btn btn-danger col-sm-3 col-xs-5 btn-margin">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
              @endforeach
              </tbody>
            <tfoot>
              <tr>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_ID: activate to sort column ascending">Staff ID</th>
                <th width="12%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Employee Name</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Department: activate to sort column ascending">Department</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_leave_days: activate to sort column ascending">Total leave Days</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="start_leave_date: activate to sort column ascending">Start Leave Date</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="end_leave_date: activate to sort column ascending">End Leave Date</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_requested: activate to sort column ascending">Leave Days Requested</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="outstanding_leave_days: activate to sort column ascending">Outstanding Leave Days</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
                </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div> 
      <div class="row">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($leave_request_form)}} of {{count($leave_request_form)}} entries</div>
        </div>
      </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection