@extends('leave_request_form.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new leave request</div>
                <div class="panel-body">
                    @if(\Session::has('success'))
                                <div class="alert alert-success">
                                    <p>{{\Session::get('sucess')}}</p>
                    @endif
                    </div>
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('leave_request_form.store') }}" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <div class="form-group{{ $errors->has('staff_ID') ? ' has-error' : '' }}">
                            <label for="staff_ID" class="col-md-4 control-label">Staff ID</label>

                            <div class="col-md-6">
                                <input id="staff_ID" type="text" class="form-control" name="staff_ID" value="{{ old('staff_ID') }}" required>

                                @if ($errors->has('staff_ID'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('staff_ID') }}</strong>
                                    </span>
                                @endif
                                
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                            <label for="firstname" class="col-md-4 control-label">First Name</label>

                            <div class="col-md-6">
                                <input id="firstname" type="text" class="form-control" name="firstname" value="{{ old('firstname') }}" required autofocus>

                                @if ($errors->has('firstname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('firstname') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('lastname') ? ' has-error' : '' }}">
                            <label for="lastname" class="col-md-4 control-label">Last Name</label>

                            <div class="col-md-6">
                                <input id="lastname" type="text" class="form-control" name="lastname" value="{{ old('lastname') }}" required>

                                @if ($errors->has('lastname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('lastname') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('middlename') ? ' has-error' : '' }}">
                            <label for="middlename" class="col-md-4 control-label">Middle Name</label>

                            <div class="col-md-6">
                                <input id="middlename" type="text" class="form-control" name="middlename" value="{{ old('middlename') }}" required>

                                @if ($errors->has('middlename'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('middlename') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('department') ? ' has-error' : '' }}">
                            <label for="department" class="col-md-4 control-label">Department</label>

                            <div class="col-md-6">
                                <input id="department" type="text" class="form-control" name="department" value="{{ old('department') }}" required>

                                @if ($errors->has('department'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('department') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('total_leave_days') ? ' has-error' : '' }}">
                            <label for="total_leave_days" class="col-md-4 control-label">Total Leave Days</label>

                            <div class="col-md-6">
                                <input id="total_leave_days" type="text" class="form-control" name="total_leave_days" value="{{ old('total_leave_days') }}" required>

                                @if ($errors->has('total_leave_days'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('total_leave_days') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Start leave date</label>
                            <div class="col-md-6">
                                <div class="input-group date">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <input type="text" value="{{ old('start_leave_date') }}"
                                    name="start_leave_date"class="form-control pull-right"
                                    id="startleaveDate" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">End leave date</label>
                            <div class="col-md-6">
                                <div class="input-group date">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <input type="text" value="{{ old('end_leave_date') }}"
                                    name="end_leave_date"class="form-control pull-right"
                                    id="endleaveDate" required>
                                </div>
                            </div>
                        </div>
                            <div class="form-group{{ $errors->has('leave_days_requested') ? ' has-error' : '' }}">
                            <label for="leave_days_requested" class="col-md-4 control-label">Leave Days Requested</label>

                            <div class="col-md-6">
                                <input id="leave_days_requested" type="text" class="form-control" name="leave_days_requested" value="{{ old('leave_days_requested') }}">

                                @if ($errors->has('leave_days_requested'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('leave_days_requested') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('outstanding_leave_days') ? ' has-error' : '' }}">
                            <label for="outstanding_leave_days" class="col-md-4 control-label">Oustanding Leave Days</label>

                            <div class="col-md-6">
                                <input id="outstanding_leave_days" type="text" class="form-control" name="outstanding_leave_days" value="{{ old('outstanding_leave_days') }}">

                                @if ($errors->has('outstanding_leave_days'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('outstanding_leave_days') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection