@extends('intcalculator.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">Monthly Interest Calculation</h3>
        </div>
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('intcalculator.create') }}">Calculate Monthly Interest</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('intcalculator.search_1') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['staff_no'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['staff_no'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="table-responsive">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_no: activate to sort column ascending">Staff Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_contribution: activate to sort column ascending">Total Contribution</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest: activate to sort column ascending">Interest Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="balance_amount: activate to sort column ascending">Balance On Contribution Amount</th>
              </tr>
            </thead>
            <tbody>
               @foreach ($Interestcalculator as $Interestcalculators)
               <tr role="row" class="odd">
                  <td class="hidden-xs">{{ $Interestcalculators->staff_no}}</td>
                  <td class="hidden-xs">{{ $Interestcalculators->name}}</td>
                  <td class="hidden-xs">{{ $Interestcalculators->total_contribution}}</td>
                  <td class="hidden-xs">{{ $Interestcalculators->interest_amount}}</td>
                  <td class="hidden-xs">{{ $Interestcalculators->balance_amount}}</td>
                  <td>
                  
                  </td>
              </tr>
              @endforeach
            </tbody>
            <tfoot>
              <tr>
                <tr role="row">
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_no: activate to sort column ascending">Staff Number</th>
                <th width="25%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Name: activate to sort column descending" aria-sort="ascending">Client Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_contribution: activate to sort column ascending">Total Contribution</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="interest: activate to sort column ascending">Interest Amount</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="balance_amount: activate to sort column ascending">Balance On Contribution Amount</th>
              </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($Interestcalculator)}} of {{count($Interestcalculator)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $Interestcalculator->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection