@extends('import.singlecontribution.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">List of Client Contributions</h3>
        </div>
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('singlecontribution.create') }}">Add New Client Payment</a>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('singlecontribution.search') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['Name', 'Clientaccount_number'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['name'] : '', isset($searchingVals) ? $searchingVals['clientaccount_number'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="30%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Client Name</th>
                <th width="20%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contributing Amount</th>
                <th width="25%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="20%" class="sorting" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Contribution Year</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
            @foreach ($client_contribution as $client_contributions)
                <tr role="row" class="odd">
                  <td>{{ $client_contributions->clientaccount_number }}</td>
                  <td>{{ $client_contributions->name }}</td>
                  <td>{{ $client_contributions->contribution_amount }}</td>
                  <td>{{ $client_contributions->contribution_month }}</td>
                  <td>{{ $client_contributions->year }}</td>
                  <td>
                    <form class="row" method="POST" action="{{ route('singlecontribution.destroy', $client_contributions->id) }}" onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <a href="{{ route('singlecontribution.edit', $client_contributions->id)}}" class="fa fa-pencil">
                        Update
                        </a>
                        <button type="submit" class="fa fa-trash">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
            @endforeach
            </tbody>
            <tfoot>
              <tr>
                <th width="30%" rowspan="1" colspan="1">Client Account Number</th>
                <th width="30%" rowspan="1" colspan="1">Client Name</th>
                <th width="30%" rowspan="1" colspan="1">Contributing Amount</th>
                <th width="30%" rowspan="1" colspan="1">Contribution Month</th>
                <th width="30%" rowspan="1" colspan="1">Contribution Year</th>
                <th rowspan="1" colspan="1">Action</th>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing {{count($client_contribution)}} to {{count($client_contribution)}} of {{count($client_contribution)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $client_contribution->links() }}
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection