@extends('import.singlecontribution.base')
@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Edit Client Contribution Record</div>
                @if (\Session::has('success'))
      <div class="alert alert-success">
        <p>{{ \Session::get('success') }}</p>
      </div><br />
     @endif
                <div class="panel-body">
                    <form method="POST" action="{{route('singlecontribution.update', $client_contributions->id)}}" enctype="multipart/form-data">
                        {{csrf_field()}}
                        <input type="hidden" name="method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group">
                    <div class="form-group{{ $errors->has('clientaccount_number') ? ' has-error' : '' }}">
                            <label for="clientaccount_number" class="col-md-4 control-label">Client Account Number</label>
                            <div class="col-md-6">
                            <input id="clientaccount_number" type="text" class="form-control" name="clientaccount_number" value="{{ $client_contributions->clientaccount_number }}" required autofocus>
                            @if ($errors->has('clientaccount_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('clientaccount_number') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                            <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                            <label for="name" class="col-md-4 control-label">Client Name</label>
                            <div class="col-md-6">
                            <input id="name" type="text" class="form-control" name="name" value="{{ $client_contributions->name }}" required autofocus>
                            @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('contribution_amount') ? ' has-error' : '' }}">
                            <label for="contribution_amount" class="col-md-4 control-label">Client Contribution Amount</label>

                            <div class="col-md-6">
                                <input id="contribution_amount" type="text" class="form-control" name="contribution_amount" value="{{ $client_contributions->contribution_amount }}" required>

                                @if ($errors->has('contribution_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('contribution_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('contribution_month') ? ' has-error' : '' }}">
                            <label for="contribution_month" class="col-md-4 control-label">Middle Name</label>

                            <div class="col-md-6">
                                <input id="contribution_month" type="text" class="form-control" name="contribution_month" value="{{ $client_contributions->contribution_month }}" required>

                                @if ($errors->has('contribution_month'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('contribution_month') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
                            <label for="year" class="col-md-4 control-label">Contribution year</label>

                            <div class="col-md-6">
                                <input id="year" type="text" class="form-control" name="year" value="{{$client_contributions->year }}" required>

                                @if ($errors->has('year'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('year') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div> 
                    <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div> 
@endsection