@extends('import.singlecontribution.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Client Payment</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('singlecontribution.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('clientaccount_number') ? ' has-error' : '' }}">
                            <label for="clientaccount_number" class="col-md-4 control-label">Client Account Number</label>

                            <div class="col-md-6">
                                <input id="clientaccount_number" type="text" class="form-control" name="clientaccount_number" value="{{ old('clientaccount_number') }}" >

                                @if ($errors->has('clientaccount_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('clientaccount_number') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                            <label for="name" class="col-md-4 control-label">Client Name</label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control" name="name" value="{{ old('name') }}" >

                                @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('contribution_amount') ? ' has-error' : '' }}">
                            <label for="contribution_amount" class="col-md-4 control-label">Client Contribution Amount</label>

                            <div class="col-md-6">
                                <input id="contribution_amount" type="text" class="form-control" name="contribution_amount" value="{{ old('contribution_amount') }}" >

                                @if ($errors->has('contribution_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('contribution_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                          <div class="form-group{{ $errors->has('contribution_month') ? ' has-error' : '' }}">
                            <label for="contribution_month" class="col-md-4 control-label">Contribution Month</label>

                            <div class="col-md-6">
                                <input id="contribution_month" type="text" class="form-control" name="contribution_month" value="{{ old('contribution_month') }}" >

                                @if ($errors->has('contribution_month'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('contribution_month') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
                            <label for="year" class="col-md-4 control-label">Contribution year</label>

                            <div class="col-md-6">
                                <input id="year" type="text" class="form-control" name="year" value="{{ old('year') }}" >

                                @if ($errors->has('year'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('year') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
