@extends('import.indivclient-report.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">Individual Contribution Report</h3>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('indivclient-report.excel') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['clientaccount_number']}}" name="clientaccount_number" />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">
           @if($client_contribution && count($client_contribution) > 0)
    @php
        $clientaccount_number = $client_contribution[0]->clientaccount_number;
        $employee = \App\Models\Employee::where('clientaccount_number', $clientaccount_number)->first();
    @endphp
          
                <form class="form-horizontal" role="form" method="POST" action="{{ route('indivclient-report.pdf') }}">
                  {{ csrf_field() }}
                    <input type="hidden" value="{{$searchingVals['clientaccount_number']}}" name="clientaccount_number" />
                    <button type="submit" class="btn btn-info">
                      Export to PDF
                    </button>
                </form>
              @endif
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('indivclient-report.search') }}">
         {{ csrf_field() }}
    
           @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['title' => 'Client Account Number', 'items' => ['Clientaccount_Number'], 'oldVals' => [isset($searchingVals) ? $searchingVals['clientaccount_number'] : '']])
          'oldVals' => [isset($searchingVals) ? $searchingVals['clientaccount_number'] : '']])
          @endcomponent
        @endcomponent
        
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="25%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Name</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="7%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Contribution Year</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
              </tr>
            </thead>
            <tbody>
             @if($client_contribution && count($client_contribution) > 0)
               @foreach ($client_contribution as $client_contributions)
                  <tr role="row" class="odd">
                    <td>{{ $client_contributions->clientaccount_number }}</td>
                    <td>{{ $client_contributions->name }}</td>
                    <td>{{ $client_contributions->contribution_month }}</td>
                    <td>{{ $client_contributions->year }}</td>
                    <td>{{ $client_contributions->contribution_amount }}</td>
                  </tr>
               @endforeach
             @else
                <tr>
                    <td colspan="5" class="text-center">No contributions found for the client account number: {{ $searchingVals['clientaccount_number'] }}</td>
                </tr>
             @endif
            </tbody>
            @if($client_contribution && count($client_contribution) > 0)
            <tfoot>
              <tr>
                <th colspan="4">Total</th>
                <th id="total"><b>{{ number_format($total, 2, '.', '') }}</b></th>
              </tr>   
            </tfoot>
            @endif
          </table>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
          @if($client_contribution && count($client_contribution) > 0)
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to 
          {{count($client_contribution)}} of {{count($client_contribution)}} entries</div>
          @endif
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection

