@extends('import.contribution-report.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="table-responsive">
        <div class="col-sm-4">
          <h3 class="box-title">Client Contribution Report</h3>
        </div>
        @if(isset($message))
    <script>
        alert("{{$message}}");
    </script>
    @endif
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('contribution-report.excel') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['clientaccount_number']}}" name="clientaccount_number" />
                <input type="hidden" value="{{$searchingVals['contribution_month']}}" name="contribution_month" />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('contribution-report.pdf') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['clientaccount_number']}}" name="clientaccount_number" />
                <input type="hidden" value="{{$searchingVals['contribution_month']}}" name="contribution_month" />
                <button type="submit" class="btn btn-info">
                  Export to PDF
                </button>
            </form>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="table-responsive">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('contribution-report.search') }}">
         {{ csrf_field() }}
          @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['clientaccount_number','contribution_month'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['clientaccount_number'] : '', isset($searchingVals) ? $searchingVals['contribution_month'] : '']])
          @endcomponent
        @endcomponent
      </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Number</th>
                <th width="25%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="7%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Contribution Year</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
              </tr>
            </thead>
            <tbody>
@if (!empty($client_contribution))
    @foreach ($client_contribution as $client_contributions)
        <tr role="row" class="odd">
            <td>{{$client_contributions->clientaccount_number}}</td>
            <td>{{$client_contributions->name}}</td>
            <td>{{$client_contributions->contribution_month}}</td>
            <td>{{$client_contributions->year}}</td>
            <td>{{$client_contributions->contribution_amount}}</td>
        </tr>
    @endforeach
@else
    <tr>
        <td colspan="5" class="text-center">No data found</td>
    </tr>
@endif
</tbody>
            <tfoot>
              <tr role="row">
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Number</th>
                <th width="25%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="7%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Contribution Year</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="row">
    <div class="col-sm-12">
        @if (is_countable($client_contribution) && count($client_contribution) > 0)
            <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">
                Showing 1 to {{ count($client_contribution) }} of {{ count($client_contribution) }} entries
            </div>
        @else
            <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">
                No entries found
            </div>
        @endif
    </div>
</div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection