@extends('employee-leaves-details.employeeleaves.base')
@section('action-content')
<!-- Main content -->
<section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-8">
          <h3 class="box-title">List of employee leave</h3>
        </div>
         @if (\Session::has('success'))
      <div class="alert alert-success">
        <p>{{ \Session::get('success') }}</p>
      </div><br />
     @endif
        <div class="col-sm-4">
          <a class="btn btn-primary" href="{{ route('employeeleaves.create') }}">Add new employee leaves</a>
          </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('employeeleaves.search') }}">
         {{ csrf_field() }}
         @component('layouts.search', ['title' => 'Search'])
          @component('layouts.two-cols-search-row', ['items' => ['Firstname'], 
          'oldVals' => [isset($searchingVals) ? $searchingVals['firstname'] : '']])
          @endcomponent
        @endcomponent
        </div>
    </form>
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width="10%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employee_id: activate to sort column descending" aria-sort="ascending">Employee ID</th>
                <th width="30%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Employee Name</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_approved: activate to sort column ascending">Leave Days Approved</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_carried_forward: activate to sort column ascending">Leave Days Carried Forward</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_leave_days: activate to sort column ascending">Total Leave Days</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_requested: activate to sort column ascending">Leave Days Requested</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="outstanding_leave_days: activate to sort column ascending">Outstanding Leave Days</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach ($employeeleave as $employeeleaves)
                <tr role="row" class="odd">
                  <td>{{$employeeleaves->employee_id}}</td>
                  <td class="sorting_1">{{ $employeeleaves->firstname }} {{$employeeleaves->middlename}} {{$employeeleaves->lastname}}</td>
                  <td>{{$employeeleaves->leave_days_approved}}</td>
                  <td>{{$employeeleaves->leave_days_carried_forward}}</td>
                  <td>{{$employeeleaves->total_leave_days}}</td>
                  <td>{{$employeeleaves->leave_days_requested}}</td>
                  <td>{{$employeeleaves->outstanding_leave_days}}</td>
                  <td>
                    <form class="row" method="POST" action="{{action('leaveController@destroy', $employeeleaves['id'])}}" onsubmit = "return confirm('Are you sure?')">
                        <input type="hidden" name="_method" value="DELETE">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <a href="{{action('leaveController@edit', $employeeleaves['id'])}}" class="btn btn-warning col-sm-3 col-xs-5 btn-margin">
                        Edit
                        </a>
                         <button type="submit" class="btn btn-danger col-sm-5 col-xs-5 btn-margin">
                          Delete
                        </button>
                    </form>
                  </td>
              </tr>
              @endforeach
              </tbody>
            <tfoot>
              <tr>
                <tr role="row">
                <th width="10%" class="sorting_asc" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="employee_id: activate to sort column descending" aria-sort="ascending">Employee ID</th>
                <th width="30%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Employee Name</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_approved: activate to sort column ascending">Leave Days Approved</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_carried_forward: activate to sort column ascending">Leave Days Carried Forward</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_leave_days: activate to sort column ascending">Total Leave Days</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_requested: activate to sort column ascending">Leave Days Requested</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="outstanding_leave_days: activate to sort column ascending">Outstanding Leave Days</th>
                <th tabindex="0" aria-controls="example2" rowspan="1" colspan="2" aria-label="Action: activate to sort column ascending">Action</th>
                </tr>
              </tr>
            </tfoot>
          </table>
        </div>
      </div> 
      <div class="row">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($employeeleave)}} of {{count($employeeleave)}} entries</div>
        </div>
        <div class="col-sm-7">
          <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
            {{ $employeeleave->links() }}
      </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection
        
        



         
            
    

      
    
   