@extends('employee-leaves-details.employeeleaves.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Edit employee leaves Records</div>
                @if (\Session::has('success'))
      <div class="alert alert-success">
        <p>{{ \Session::get('success') }}</p>
      </div><br />
     @endif
                <div class="panel-body">
                    <form method="POST" action="{{route('employeeleaves.update', ['id' => $employeeleaves->id])}}" enctype="multipart/form-data">
                        {{csrf_field()}}
                        <input type="hidden" name="method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group">
                            <div class="form-group{{ $errors->has('employee_id') ? ' has-error' : '' }}">
                            <label for="employee_id" class="col-md-4 control-label">Employee ID</label>
                            <div class="col-md-6">
                            <input id="employee_id" type="text" class="form-control" name="employee_id" value="{{ $employeeleaves->employee_id }}" required autofocus>
                            @if ($errors->has('employee_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('employee_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                            <div class="form-group{{ $errors->has('lastname') ? ' has-error' : '' }}">
                            <label for="lastname" class="col-md-4 control-label">Last Name</label>
                            <div class="col-md-6">
                            <input id="lastname" type="text" class="form-control" name="lastname" value="{{ $employeeleaves->lastname }}" required autofocus>
                            @if ($errors->has('lastname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('lastname') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                            <label for="firstname" class="col-md-4 control-label">First Name</label>

                            <div class="col-md-6">
                                <input id="firstname" type="text" class="form-control" name="firstname" value="{{ $employeeleaves->firstname }}" required>

                                @if ($errors->has('firstname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('firstname') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('middlename') ? ' has-error' : '' }}">
                            <label for="middlename" class="col-md-4 control-label">Middle Name</label>

                            <div class="col-md-6">
                                <input id="middlename" type="text" class="form-control" name="middlename" value="{{ $employeeleaves->middlename }}" required>

                                @if ($errors->has('middlename'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('middlename') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('leave_days_approved') ? ' has-error' : '' }}">
                            <label for="leave_days_approved" class="col-md-4 control-label">Leave Days Approved</label>

                            <div class="col-md-6">
                                <input id="leave_days_approved" type="text" class="form-control" name="leave_days_approved" value="{{$employeeleaves->leave_days_approved }}" required>

                                @if ($errors->has('leave_days_approved'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('leave_days_approved') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('leave_days_carried_forward') ? ' has-error' : '' }}">
                            <label for="leave_days_carried_forward" class="col-md-4 control-label">Leave Days Carried Forward</label>

                            <div class="col-md-6">
                                <input id="leave_days_carried_forward" type="text" class="form-control" name="leave_days_carried_forward" value="{{$employeeleaves->leave_days_carried_forward }}" required>

                                @if ($errors->has('leave_days_carried_forward'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('leave_days_carried_forward') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('total_leave_days') ? ' has-error' : '' }}">
                            <label for="total_leave_days" class="col-md-4 control-label">Total Leave Days</label>

                            <div class="col-md-6">
                                <input id="total_leave_days" type="text" class="form-control" name="total_leave_days" value="{{ $employeeleaves->total_leave_days }}" required>

                                @if ($errors->has('total_leave_days'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('total_leave_days') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('leave_days_requested') ? ' has-error' : '' }}">
                            <label for="leave_days_requested" class="col-md-4 control-label">Leave Days Requested</label>

                            <div class="col-md-6">
                                <input id="leave_days_requested" type="text" class="form-control" name="leave_days_requested" value="{{ $employeeleaves->leave_days_requested }}">

                                @if ($errors->has('leave_days_requested'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('leave_days_requested') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('outstanding_leave_days') ? ' has-error' : '' }}">
                            <label for="outstanding_leave_days" class="col-md-4 control-label">Outstanding Leave Days</label>
                            <div class="col-md-6">
                                <input id="outstanding_leave_days" type="text" class="form-control" name="outstanding_leave_days" value="{{ $employeeleaves->outstanding_leave_days }}">

                                @if ($errors->has('outstanding_leave_days'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('outstanding_leave_days') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </form>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary" value="Update" />
                                Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
