@extends('employee-leaves-details.leave-report-all.base')
@section('action-content')
    <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">ALL Employee Leave Report</h3>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('leave-report-all.excel') }}">
              {{ csrf_field() }}
                <input type="hidden" value=" " />
                <button type="submit" class="btn btn-primary">
                  Export to Excel
                </button>
            </form>
        </div>
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('leave-report-all.pdf') }}">
              {{ csrf_field() }}
                <input type="hidden" value=" " />
                <button type="submit" class="btn btn-info">
                  Export to PDF
                </button>
            </form>
        </div>
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <th width = "10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Employee Name</th>
                <th width = "12%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_approved: activate to sort column ascending">Leave Days Approved</th>
                <th width = "12%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_carried_forward: activate to sort column ascending">Leave Days Carried Forward</th>
                <th width = "12%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_leave_days: activate to sort column ascending">Total Leave Days</th>
                <th width = "8%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_requested: activate to sort column ascending">Leave Days Requested</th>
                <th width = "8%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="outstanding_leave_days: activate to sort column ascending">Outstanding Leave Days</th>  
              </tr>
            </thead>
            <tbody>
            @foreach ($employeeleave as $employeeleaves)
                <tr role="row" class="odd">
                  <td>{{ $employeeleaves->firstname }} {{$employeeleaves->middlename}} {{$employeeleaves->lastname}}</td>
                  <td>{{$employeeleaves->leave_days_approved}}</td>
                  <td>{{$employeeleaves->leave_days_carried_forward}}</td>
                  <td>{{$employeeleaves->total_leave_days}}</td>
                  <td>{{$employeeleaves->leave_days_requested}}</td>
                  <td>{{$employeeleaves->outstanding_leave_days}}</td>
              </tr>
            @endforeach
            </tbody>
            <tfoot>
              <tr role="row">
                <th width = "10%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Employee Name</th>
                <th width = "12%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_approved: activate to sort column ascending">Leave Days Approved</th>
                <th width = "12%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_carried_forward: activate to sort column ascending">Leave Days Carried Forward</th>
                <th width = "12%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="total_leave_days: activate to sort column ascending">Total Leave Days</th>
                <th width = "8%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="leave_days_requested: activate to sort column ascending">Leave Days Requested</th>
                <th width = "8%" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="outstanding_leave_days: activate to sort column ascending">Outstanding Leave Days</th>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($employeeleave)}} of {{count($employeeleave)}} entries</div>
        </div>
      </div>
    </div>
  </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection