@extends('dailyinterestcal.base')

@section('action-content')
<!DOCTYPE html>
<html>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
<link href="https://fonts.googleapis.com/css?family=Raleway" rel="stylesheet">
<script src="jquery.js"></script>
<script src="{{asset('js/bootstrap.js')}}"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<div class="container">
    <div class="row">
        <div class="col-sm-11"> 
            <div class="panel panel-default">
                <div class="panel-heading">Create New Investment</div>
                @if (\Session::has('success'))
      <div class="alert alert-success">
        <p>{{ \Session::get('success') }}</p>
      </div><br />
     @endif


                <div class="panel-body">
                    <form  class="form-horizontal" method="POST" action="{{ url('dailyinterestcal/search') }}">
                        {{csrf_field()}}

        @component('layouts.search', ['title' => 'Search'])
    @component('layouts.two-cols-search-row', [
        'items' => ['contribution_month', 'year', 'clientaccount_number'], 
        'oldVals' => [
            isset($searchingVals) ? $searchingVals['contribution_month'] : '', 
            isset($searchingVals) ? $searchingVals['year'] : '', 
            isset($searchingVals) ? $searchingVals['clientaccount_number'] : ''
        ]
    ])
    @endcomponent
@endcomponent


                    </form>
                    

                @if(isset($studentkyc))
<form class="form-horizontal" role="form" method="POST" id="form_id" action="{{ route('dailyinterestcal.store') }}">
                        {{ csrf_field() }}
    <div class="form-group">
                           
                        {{csrf_field()}}   
        <input type="hidden" name="intYear" value="{{ $searchingVals['year'] }}">
        <input type="hidden" name="intMonth" value="{{ $searchingVals['contribution_month'] }}">
        <input type="hidden" name="intclientaccount_number" value="{{ $searchingVals['clientaccount_number'] }}">

    @foreach($client_contributions as $contribution)
  <div class="form-row col-md-4">
    <label for="clientaccount_number">Client Account Number</label>
    <input id="clientaccount_number" type="text" class="form-control" name="clientaccount_number" placeholder="client account number" value="{{ $contribution->clientaccount_number }}" readonly="">
    </div>
    <div class="form-row col-md-4">
    <label for="name">Client Name</label>
    <input id="name" type="text" class="form-control" name="name" placeholder="Name" value="{{ $contribution->firstname }} {{ $contribution->middlename }} {{ $contribution->lastname }}" readonly>
    </div>
    <div class="form-row col-md-4">
    <label for="contribution_amount">Contribution</label>
    <input id="contribution_amount" type="text" class="form-control" name="contribution_amount" placeholder="contribution_amount" value="{{$contribution->contribution_amount}}" readonly>
    </div>
    @endforeach

    
    @foreach($studentkyc as $studentkycs)
            @php
                $contribution = $client_contributions->where('clientaccount_number', $studentkycs->clientaccount_number)->first();
            @endphp
            @if($contribution)
    <div class="form-row col-md-4">
        <label for="fundtype">Fund Type</label>
         <select class="form-control" name="fundtype_id" readonly>
            @foreach ($fundtype as $fundtypes)
                <option {{ $studentkycs->fundtype_id == $fundtypes->id ? 'selected' : '' }} value="{{ $fundtypes->id }}">{{ $fundtypes->fundtype_name }}</option>
            @endforeach
        </select>
                            </div>
        <div class="form-row col-md-4">
        <label for="fixedincometype">Investment Type</label>
         <select class="form-control" name="fixedincometype_id" id="fixedincometype_id">
            <option value="-1">Please select Investment Type</option>
            @foreach ($Fixedincometype as $Fixedincometypes)
                <option value="{{$Fixedincometypes->id}}">{{$Fixedincometypes->fixedincometype_name}}</option>
            @endforeach
        </select>
                            </div>
            <div class="form-row col-md-4">
        <label for="fixedincometype">Investment product</label>
         <select class="form-control" name="fixedincomeproduct_id" id="fixedincomeproduct_id">
            <option value="-1">Please select Investment product</option>
            @foreach ($Fixedincomeproduct as $Fixedincomeproducts)
                <option value="{{$Fixedincomeproducts->id}}">{{$Fixedincomeproducts->fixedincomeproduct_name}}</option>
            @endforeach
        </select>
                            </div>
        <div class="form-row col-md-4">
        <label for="interestdaybasis">Interest Day Basis</label>
         <select class="form-control" name="interestdaybasis_id" id="interestdaybasis_id">
            <option value="-1">Please select Investment product</option>
            @foreach ($interestday as $interestdays)
                <option value="{{$interestdays->id}}">{{$interestdays->interestdaybasis}}</option>
            @endforeach
        </select>
                            </div>
        <div class="form-row col-md-4">
    <label for="tenor">Tenor</label>
    <input id="tenor" type="text" class="form-control" name="tenor" placeholder="tenor" value="{{ old('tenor') }}" nullable >
    </div>
    <div class="form-row col-md-4">
        <label for="interesttype">Interest Type</label>
         <select class="form-control" name="interesttype_id" id="interesttype_id">
            <option value="-1">Please select Interest Type</option>
            @foreach ($Interesttype as $Interesttypes)
                <option value="{{$Interesttypes->id}}">{{$Interesttypes->interesttype}}</option>
            @endforeach
        </select>
                            </div>

    <div class="form-row col-md-4">
        <label for="interestratetype">Type of Interest Rate</label>
         <select class="form-control" name="interestratetype_id" id="interestratetype_id">
            <option value="-1">Please select Interest Rate Type</option>
            @foreach ($Interestratetype as $Interestratetypes)
                <option value="{{$Interestratetypes->id}}">{{$Interestratetypes->interestratetype}}</option>
            @endforeach
        </select>
                            </div>
    <div class="form-row col-md-4">
    <label for="interest_rate">Interest Rate(%)</label>
    <input id="interest_rate" type="text" class="form-control" name="interest_rate" placeholder="Interest rate" value="{{ old('interest_rate') }}" nullable oninput="calculateAnnualIntRate()">
</div>
<div class="form-row col-md-4">
        <label for="counterparty">Counter Party</label>
         <select class="form-control" name="counterparty_id" id="counterparty_id">
            <option value="-1">Please select Counter Party</option>
            @foreach ($counterparty as $counterpartys)
                <option value="{{$counterpartys->id}}">{{$counterpartys->counterparty}}</option>
            @endforeach
        </select>
                            </div>

                            @endif
                            @endforeach
               
                    </div>

                <hr>

<div class="form-group">
    <div class="col-sm-2 col-xs-1">
    {!! Form::button('Select All',['class' => 'btn btn-info form-control','onClick'=>'select_all("agree", "1")']) !!}
    </div>
            <label class="col-md-2 control-label">Date Of Transaction</label>
                            <div class="col-md-3">
                                <div class="input-group date">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <input type="date" value="{{ old('incident_date') }}"
                                    name="incident_date"class="form-control pull-right"
                                    id="incident_date" required>
                                </div>
                            </div>
        <div class="col-sm-2 col-xs-1">
    {!! Form::button('Clear All',['class' => 'btn btn-danger form-control','onClick'=>'select_all("agree", "0")']) !!}
    </div>

    <div class="col-sm-2 col-xs-1">
        <button type="submit" class="btn btn-primary">
                    Calculate
                    </button>
             </div>
            </div>
         

<div class="form-group {{ $errors->has('annualint_rate') ? ' has-error' : '' }}">
    <label for="annualint_rate" class="col-md-1 control-label">Annual Interest Rate</label>
    <div class="col-md-2">
        <input id="annualint_rate" type="text" class="form-control" name="annualint_rate" value="{{ old('annualint_rate') }}" nullable readonly>

        @if ($errors->has('annualint_rate'))
            <span class="help-block">
                <strong>{{ $errors->first('annualint_rate') }}</strong>
            </span>
        @endif
    </div>

            <label class="col-md-1 control-label">Type of Transaction</label>
                            <div class="col-md-3">
                                <select class="form-control" name="transaction_id">
                                    <option value="-1">Please select Transaction</option>
                                    @foreach ($Transaction as $Transactions)
                                        <option value="{{$Transactions->id}}">{{$Transactions->transaction_type}}</option>
                                    @endforeach
                                </select>
                            </div>
                
            <label for="narration" class="col-md-1 control-label">Narration </label>
                            <div class="col-md-3">
                                <input id="narration" type="text" class="form-control" name="narration" value="{{ old('narration') }}" nullable>

                                @if ($errors->has('narration'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('narration') }}</strong>
                                    </span>
                                @endif
                            </div>
                    </div>
      <div class="form-group {{ $errors->has('investmentstart_date') ? ' has-error' : '' }}">                 
            <label class="col-md-3 control-label">Investment Start Date</label>
                            <div class="col-md-2">
                                <div class="input-group date">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <input type="date" value="{{ old('investmentstart_date') }}"
                                    name="investmentstart_date"class="form-control pull-right"
                                    id="investmentstart_date" required>
                                </div>
                            </div>
            <label class="col-md-3 control-label">Maturity Date</label>
                            <div class="col-md-2">
                                <div class="input-group date">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <input type="date" value="{{ old('investmentend_date') }}"
                                    name="investmentend_date"class="form-control pull-right"
                                    id="investmentend_date" readonly>
                                </div>
                            </div>
       </div>

                        
    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="table-responsive">
        <div class="col-sm-12">
          <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
            <thead>
              <tr role="row">
                <div class="table-responsive">
                <th width="3%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="questionCheckBox: activate to sort column ascending"></th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="clientaccount_number: activate to sort column ascending">Client Account Number</th>
                <th width="12%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Name</th>
                <th width="10%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_month: activate to sort column ascending">Contribution Month</th>
                <th width="7%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="year: activate to sort column ascending">Contribution Year</th>
                <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
                </div>
              </tr>
            </thead>
            <tbody>
                <?php $i =0;?>
                @foreach ($client_contributions as $client_contribution)
                <tr role="row" class="odd">
            <td class="text-left">{!! Form::checkbox("agree[]", $client_contribution->clientaccount_number, null,['id' => $client_contribution->clientaccount_number], ['class' => 'questionCheckbox']) !!}</td>
            
                  <td>{{$client_contribution->clientaccount_number}}</td>
                  <td>{{$client_contribution->name}}</td>
                  <td> {{$client_contribution->contribution_month}}</td>
                  <td>{{$client_contribution->year}}</td>
                  <td>{{$client_contribution->contribution_amount}}</td>
                  
              </tr>
            @endforeach
            
            </tbody>
        </table>
        </div>
    </div>
</div>
               
                        
                    </form>
                    @endif
                    
                </div>
    <script type="text/javascript">

    var formblock;
    var forminputs;

    function prepare() {
        formblock= document.getElementById('form_id');
        forminputs = formblock.getElementsByTagName('input');
    }

    function select_all(name, value) {
        for (i = 0; i < forminputs.length; i++) {
            // regex here to check name attribute
            var regex = new RegExp(name, "i");
            if (regex.test(forminputs[i].getAttribute('name'))) {
                if (value == '1') {
                    forminputs[i].checked = true;
                } else {
                    forminputs[i].checked = false;
                }
            }
        }
    }

    if (window.addEventListener) {
        window.addEventListener("load", prepare, false);
    } else if (window.attachEvent) {
        window.attachEvent("onload", prepare)
    } else if (document.getElementById) {
        window.onload = prepare;
    }


    $(document).ready(function() {
    $('#tenor, #investmentstart_date').on('input', function() {
        calculateEndDate();
    });

    function calculateEndDate() {
        const startDate = new Date($('#investmentstart_date').val());
        const tenorDays = parseInt($('#tenor').val());

        if (!isNaN(startDate.getTime()) && !isNaN(tenorDays)) {
            const endDate = new Date(startDate);
            endDate.setDate(startDate.getDate() + tenorDays); // Add tenor days to the start date
            
            // Format the date as YYYY-MM-DD
            const formattedEndDate = endDate.toISOString().split('T')[0];
            
            $('#investmentend_date').val(formattedEndDate);
        }
    }
});

    function calculateAnnualIntRate() {
        let interestRate = document.getElementById('interest_rate').value;

        // Ensure the interest rate is a valid number before calculating
        if (!isNaN(interestRate) && interestRate !== '') {
            let annualIntRate = (parseFloat(interestRate) / 100) / 364;

            // Set the calculated value in the annualint_rate input field
            document.getElementById('annualint_rate').value = annualIntRate.toFixed(6);  // Six decimal places for precision
        } else {
            // Clear the field if the input is not a number
            document.getElementById('annualint_rate').value = '';
        }
    }

</script>
            </div>
        </div>
    </div>
</div>
@endsection





