@extends('clientsms.base')
@section('action-content')
     <!-- Main content -->
    <section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">SMS PDF Report By Regions</h3>
        </div>
     @if(session()->has('message'))
                        <div class="alert alert-success">
                            {{ session()->get('message') }}
                        </div>
                    @endif
        <div class="col-sm-4">
        <form class="form-horizontal" role="form" method="POST" action="{{ route('clientsms.sms') }}">
              {{ csrf_field() }}
                <input type="hidden" value="{{$searchingVals['state_name']}}" name="state_id" />
                <button type="submit" class="btn btn-primary">
                  Send SMS
                </button>
            </form>
        </div>
                
    </div>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
      <div class="row">
        <div class="col-sm-6"></div>
        <div class="col-sm-6"></div>
      </div>
      <form method="POST" action="{{ route('clientsms.search') }}">
          {{csrf_field()}}
           <div class="row">
             <div class="col-md-6">
              <label> Select region </label>
               <select class="form-control" name="state_id">
                <option value="-1">Please select region</option>
                
                @foreach($regions as $region)
                    @if( Auth::user()->state_id == $region->id )
                      <option value="{{$region->id}}"> {{$region->state_name}}</option>
                    @elseif(Auth::user()->user_type == 'admin')
                       <option value="{{$region->id}}"> {{$region->state_name}}</option>
                    @endif
                 @endforeach 
              </select>           

             </div>
             <div class="col-md-6">
              
             </div>
           </div>
           <br>
            <button class="btn btn-primary" type="submit">Search</button>

            <hr>

      </form>

    <div id="example2_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
      <div class="row">
        <div class="col-sm-12">

            @if($client_contribution)
               @foreach ($client_contribution as $cl)

               @php
                $staff_no = $cl->staff_number;
                $employee = \App\Employee::where('staff_number', $staff_no)->first();

               @endphp

                @if($employee->active_id == 1)

                  <div class="box box-widget">

                   <table class="table table-striped table-hover">
                    <tr>
                      <td>
                          Staff No
                      </td>
                      <td>
                        {{ $cl->staff_number }}
                      </td>
                    </tr>
                    <tr>
                      <td>
                          Staff Name
                      </td>
                      <td>
                        {{ $cl->firstname }} {{ $cl->middlename }} {{ $cl->lastname }}
                      </td>
                    </tr>
                  </table>

                  <p class="text-success"> Details of   {{ $cl->firstname }} {{ $cl->middlename }} {{ $cl->lastname }}'s contribution </p>
          
                      <table id="example2" class="table table-bordered table-hover dataTable" role="grid" aria-describedby="example2_info">
                          <thead>
                            <tr role="row">
                              <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="staff_no: activate to sort column ascending">Contribution Year</th>
                              <th width="25%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="name: activate to sort column ascending">Contribution Month</th>
                              <th width="8%" class="sorting hidden-xs" tabindex="0" aria-controls="example2" rowspan="1" colspan="1" aria-label="contribution_amount: activate to sort column ascending">Contribution Amount</th>
                            </tr>
                          </thead>
                          <tbody>
                       <?php $sum = 0 ?>
                           @foreach($cl->clientContributions as $contribution)

                            <tr>
                              <td>
                               {{$contribution->year}}
                              </td>
                              <td>
                               {{ $contribution->contribution_month }}
                              </td>
                              <td>
                                {{ $contribution->contribution_amount }}
                              </td>
                            </tr>
                            <?php $contribution = $contribution->contribution_amount ? $contribution->contribution_amount : 0;

        $sum = $sum + $contribution;

       ?>
                           @endforeach
                          </tbody>
                <tr>
                <th colspan="2">Total</th>
                <th id="total">{{$sum}}</th>
                  </tr> 
                         
                        </table>
               </div>
               <br>

                @endif
               
               @endforeach
            @endif
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
          @if($regions)
          
          @endif
        </div>
      </div>
    </div>
  </div>
  <div class="table-responsive">
        <div class="col-sm-5">
          <div class="dataTables_info" id="example2_info" role="status" aria-live="polite">Showing 1 to {{count($regions)}} of {{count($regions)}} entries</div>
        </div>
        

        
        
        

        
      </div>
  <!-- /.box-body -->
</div>
    </section>
    <!-- /.content -->
  </div>
@endsection